/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.patterns.dialogs;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Port;
import org.polarsys.chess.patterns.dialogs.AbstractMappingDialog;
import org.polarsys.chess.patterns.profile.PatternsProfile.Pattern;

public class PortMappingDialog
extends AbstractMappingDialog {
    public PortMappingDialog(Shell shell, Model chessModel, Pattern pattern, Class modelCtx, Map<NamedElement, NamedElement> mappings, Image patternPreview) {
        super(shell, chessModel, modelCtx, pattern, patternPreview);
        this.mappings = mappings;
    }

    @Override
    public void create() {
        super.create();
        this.setMessage("Map Ports");
    }

    @Override
    protected List<NamedElement> getPatternInput() {
        ArrayList<NamedElement> result = new ArrayList<NamedElement>();
        for (ConnectableElement collRole : this.pattern.getBase_Collaboration().getCollaborationRoles()) {
            if (!(collRole.getType() instanceof Class)) continue;
            Class type = (Class)collRole.getType();
            for (Port port : type.getOwnedPorts()) {
                if (result.contains(port)) continue;
                result.add((NamedElement)port);
                this.mappings.put(port, null);
            }
        }
        return result;
    }

    @Override
    protected void updateCandidates() {
        Class owner = null;
        if (this.patternElem.getOwner() instanceof Class) {
            owner = (Class)this.patternElem.getOwner();
        }
        if (owner != null) {
            Class mappedClass = null;
            boolean found = false;
            for (NamedElement key : this.mappings.keySet()) {
                if (!key.equals(owner) || found) continue;
                mappedClass = (Class)this.mappings.get(key);
                found = true;
            }
            if (mappedClass != null) {
                this.candidates.addAll(mappedClass.getOwnedPorts());
            }
        }
    }
}

