/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.tradeoffAnalysis.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.part.ViewPart;
import org.polarsys.chess.service.core.utils.AnalysisResultUtil;

public class TradeoffView
extends ViewPart {
    public static final String ID = "org.polarsys.chess.tradeoffAnalysis.views.TradeoffView";
    private TableViewer viewer;
    private Composite parent;

    public void createPartControl(Composite parent) {
        this.parent = parent;
        GridLayout layout = new GridLayout(2, false);
        parent.setLayout((Layout)layout);
        this.createViewer(parent);
    }

    private void displayResult(Row row) {
        if (row.getAnalysisName() != null && row.getResultFilePath() != null) {
            AnalysisResultUtil.getInstance().showResult("ocra_check_refinement", row.getResultFilePath());
        }
    }

    private void createViewer(Composite parent) {
        this.viewer = new TableViewer(parent, 68354);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        this.viewer.getControl().setLayoutData((Object)gridData);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection == null) {
                    return;
                }
                Object row = selection.getFirstElement();
                if (row instanceof Row) {
                    TradeoffView.this.displayResult((Row)row);
                }
            }
        });
    }

    public void createColumns(TableViewer viewer, List<String> labels) {
        TableColumn[] columns;
        TableColumn[] tableColumnArray = columns = viewer.getTable().getColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn = tableColumnArray[n2];
            tableColumn.dispose();
            ++n2;
        }
        this.createColumns(this.parent, viewer, labels);
    }

    private void createColumns(Composite parent, TableViewer viewer, List<String> labels) {
        int columnNumber = 0;
        for (String label : labels) {
            TableViewerColumn col = this.createTableViewerColumn(viewer, label, columnNumber);
            col.setLabelProvider((CellLabelProvider)new IndexedColumnLabelProvider(columnNumber++));
        }
    }

    private TableViewerColumn createTableViewerColumn(TableViewer viewer, String label, int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(label);
        switch (colNumber) {
            case 0: {
                column.setWidth(200);
                break;
            }
            case 1: {
                column.setWidth(0);
                break;
            }
            case 2: {
                column.setWidth(0);
                break;
            }
            default: {
                column.setWidth(200);
            }
        }
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    public void setFocus() {
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    private class IndexedColumnLabelProvider
    extends ColumnLabelProvider {
        private int columnNumber;
        Color redColor;
        Color greenColor;

        public IndexedColumnLabelProvider(int columnNumber) {
            this.columnNumber = columnNumber;
            this.greenColor = Display.getCurrent().getSystemColor(6);
            this.redColor = Display.getCurrent().getSystemColor(4);
        }

        public Color getForeground(Object element) {
            Row request = (Row)element;
            if (this.columnNumber > 2) {
                if (request.getResults().get(this.columnNumber - 3).equals("Success")) {
                    return this.greenColor;
                }
                if (request.getResults().get(this.columnNumber - 3).equals("NOT OK")) {
                    return this.redColor;
                }
            }
            return super.getForeground(element);
        }

        public String getText(Object element) {
            Row request = (Row)element;
            if (this.columnNumber == 0) {
                return request.getRowName();
            }
            if (this.columnNumber == 1) {
                return request.getAnalysisName();
            }
            if (this.columnNumber == 2) {
                return request.getResultFilePath();
            }
            if (this.columnNumber > 2) {
                return request.getResults().get(this.columnNumber - 3);
            }
            return null;
        }
    }

    public static class Row {
        private String rowName;
        private String analysisName;
        private String resultFilePath;
        private List<String> results;

        public Row(String rowName) {
            this.rowName = rowName;
            this.results = new ArrayList<String>();
        }

        public String getRowName() {
            return this.rowName;
        }

        public void setRowName(String rowName) {
            this.rowName = rowName;
        }

        public String getAnalysisName() {
            return this.analysisName;
        }

        public void setAnalysisName(String analysisName) {
            this.analysisName = analysisName;
        }

        public String getResultFilePath() {
            return this.resultFilePath;
        }

        public void setResultFilePath(String resultFilePath) {
            this.resultFilePath = resultFilePath;
        }

        public void addResult(String result) {
            this.results.add(result);
        }

        public List<String> getResults() {
            return this.results;
        }
    }
}

