/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.wizards.wizards;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.polarsys.chess.core.util.CHESSProjectSupport;
import org.polarsys.chess.wizards.wizards.CreateCHESSModelWizard;

public class CHESSNewProjectWizard
extends CreateCHESSModelWizard
implements INewWizard,
IExecutableExtension {
    private static final String WIZARD_NAME = "CHESS";
    private WizardNewProjectCreationPage pageOne;
    private IConfigurationElement configurationElement;

    public CHESSNewProjectWizard() {
        this.setWindowTitle(WIZARD_NAME);
    }

    @Override
    public void addPages() {
        this.pageOne = new WizardNewProjectCreationPage("CHESS Project Wizard");
        this.pageOne.setTitle("New CHESS Project");
        this.pageOne.setDescription("Create a new CHESS Project");
        this.addPage((IWizardPage)this.pageOne);
        super.addPages();
    }

    @Override
    public boolean performFinish() {
        String name = this.pageOne.getProjectName();
        java.net.URI location = null;
        if (!this.pageOne.useDefaults()) {
            location = this.pageOne.getLocationURI();
            System.err.println("location: " + location.toString());
        }
        CHESSProjectSupport.createProject((String)name, location);
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configurationElement);
        return super.performFinish();
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.configurationElement = config;
    }

    @Override
    public boolean isCreateProjectWizard() {
        return true;
    }

    @Override
    protected URI createNewModelURI(String categoryId) {
        IPath newFilePath = this.pageOne.getProjectHandle().getFullPath().append(String.valueOf(this.pageOne.getProjectName()) + "." + this.getDiagramFileExtension(categoryId));
        return URI.createPlatformResourceURI((String)newFilePath.toString(), (boolean)true);
    }
}

