/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.preferences;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.ant.core.IAntClasspathEntry;
import org.eclipse.ant.internal.core.AntClasspathEntry;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.preferences.AntClasspathBlock;
import org.eclipse.ant.internal.ui.preferences.AntPreferencesMessages;
import org.eclipse.ant.internal.ui.preferences.AntRuntimePreferencePage;
import org.eclipse.ant.internal.ui.preferences.ClasspathModel;
import org.eclipse.ant.internal.ui.preferences.IAntBlockContainer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.PlatformUI;

public class AntClasspathPage
implements IAntBlockContainer {
    private AntClasspathBlock fAntClasspathBlock = new AntClasspathBlock();
    private AntRuntimePreferencePage fPreferencePage;
    private ClasspathModel fModel;

    public AntClasspathPage(AntRuntimePreferencePage preferencePage) {
        this.fPreferencePage = preferencePage;
    }

    protected IAntClasspathEntry[] getAdditionalEntries() {
        return this.fModel.getEntries(1);
    }

    protected IAntClasspathEntry[] getAntHomeEntries() {
        return this.fModel.getEntries(0);
    }

    protected IAntClasspathEntry[] getContributedEntries() {
        return this.fModel.getEntries(3);
    }

    protected String getAntHome() {
        return this.fAntClasspathBlock.getAntHome();
    }

    protected void initialize() {
        AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
        this.createClasspathModel();
        this.fAntClasspathBlock.initializeAntHome(prefs.getAntHome());
        this.fAntClasspathBlock.setInput(this.fModel);
        this.fPreferencePage.setErrorMessage(null);
        this.fPreferencePage.setValid(true);
    }

    protected void createClasspathModel() {
        this.fModel = new ClasspathModel();
        AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
        this.fModel.setAntHomeEntries(prefs.getAntHomeClasspathEntries());
        this.fModel.setGlobalEntries(prefs.getAdditionalClasspathEntries());
        this.fModel.setContributedEntries(prefs.getContributedClasspathEntries());
    }

    protected void performDefaults() {
        AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
        this.fModel = new ClasspathModel();
        this.fModel.setAntHomeEntries(prefs.getDefaultAntHomeEntries());
        List<IAntClasspathEntry> additionalEntries = this.getDefaultAdditionalEntries();
        if (additionalEntries != null) {
            this.fModel.setGlobalEntries(additionalEntries.toArray(new IAntClasspathEntry[additionalEntries.size()]));
        } else {
            this.fModel.setGlobalEntries(new IAntClasspathEntry[0]);
        }
        this.fModel.setContributedEntries(prefs.getContributedClasspathEntries());
        this.fAntClasspathBlock.initializeAntHome(prefs.getDefaultAntHome());
        this.fAntClasspathBlock.setInput(this.fModel);
        this.update();
    }

    private List<IAntClasspathEntry> getDefaultAdditionalEntries() {
        IAntClasspathEntry toolsJarEntry = AntCorePlugin.getPlugin().getPreferences().getToolsJarEntry();
        File libDir = new File(System.getProperty("user.home"), ".ant" + File.separatorChar + "lib");
        URL[] urls = null;
        try {
            urls = this.getLocationURLs(libDir);
        }
        catch (MalformedURLException e) {
            AntUIPlugin.log(e);
            return new ArrayList<IAntClasspathEntry>(0);
        }
        ArrayList<IAntClasspathEntry> entries = new ArrayList<IAntClasspathEntry>(urls.length);
        URL[] uRLArray = urls;
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            AntClasspathEntry entry = new AntClasspathEntry(url);
            entries.add((IAntClasspathEntry)entry);
            ++n2;
        }
        if (toolsJarEntry != null) {
            entries.add(toolsJarEntry);
        }
        return entries;
    }

    private URL[] getLocationURLs(File location) throws MalformedURLException {
        URL[] urls = new URL[]{};
        if (!location.exists()) {
            return urls;
        }
        if (!location.isDirectory()) {
            urls = new URL[1];
            String path = location.getPath();
            if (path.toLowerCase().endsWith(".jar")) {
                urls[0] = location.toURI().toURL();
            }
            return urls;
        }
        File[] matches = location.listFiles((dir, name) -> name.toLowerCase().endsWith(".jar"));
        urls = new URL[matches.length];
        int i = 0;
        while (i < matches.length) {
            urls[i] = matches[i].toURI().toURL();
            ++i;
        }
        return urls;
    }

    protected TabItem createTabItem(TabFolder folder) {
        TabItem item = new TabItem(folder, 0);
        item.setText(AntPreferencesMessages.AntClasspathPage_title);
        item.setImage(this.fAntClasspathBlock.getClasspathImage());
        item.setData((Object)this);
        item.setControl((Control)this.createContents((Composite)folder));
        return item;
    }

    protected Composite createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.ant.ui.ant_classpath_page_context");
        Font font = parent.getFont();
        Composite top = new Composite(parent, 0);
        top.setFont(font);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)new GridData(1808));
        this.fAntClasspathBlock.setContainer(this);
        this.fAntClasspathBlock.createContents(top);
        return top;
    }

    @Override
    public void update() {
        if (this.fAntClasspathBlock.isValidated()) {
            return;
        }
        this.setMessage(null);
        this.setErrorMessage(null);
        boolean valid = this.fAntClasspathBlock.validateAntHome();
        if (valid) {
            valid = this.fAntClasspathBlock.validateToolsJAR();
        }
        this.fPreferencePage.setValid(valid);
    }

    @Override
    public void setMessage(String message) {
        this.fPreferencePage.setMessage(message);
    }

    @Override
    public void setErrorMessage(String message) {
        this.fPreferencePage.setErrorMessage(message);
    }

    @Override
    public Button createPushButton(Composite parent, String buttonText) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        button.setText(buttonText);
        this.fPreferencePage.setButtonLayoutData(button);
        return button;
    }
}

