/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

public abstract class GraphvizDotBuilder {
    protected static final Logger log = Logger.getLogger(GraphvizDotBuilder.class);
    private static final Pattern noEsc = Pattern.compile("[a-zA-Z0-9]+");

    public String draw(Object obj) {
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        this.draw(obj, new PrintStream(ba));
        return ba.toString();
    }

    public void draw(Object obj, PrintStream out) {
        out.println("## This is a Graphviz .dot file (http://www.graphviz.org/)");
        out.println("## You can use the command 'dot -Tpdf this.dot > out.pdf' to render it.");
        this.drawObject(obj).draw(out);
    }

    public void draw(Object obj, String outfile, String options) throws IOException {
        String cmd = this.getGraphvizBinary() + " -o " + outfile + " " + options;
        this.draw(obj, cmd);
    }

    public void draw(Object obj, String cmd) throws IOException {
        int b;
        log.info((Object)("Running '" + cmd + "' in '" + new File(".").getCanonicalPath() + "'"));
        Process p = Runtime.getRuntime().exec(cmd);
        PrintStream ps = new PrintStream(p.getOutputStream());
        BufferedInputStream in = new BufferedInputStream(p.getInputStream());
        BufferedInputStream err = new BufferedInputStream(p.getErrorStream());
        this.draw(obj, ps);
        ps.close();
        ByteArrayOutputStream oerr = new ByteArrayOutputStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((b = err.read()) >= 0) {
            oerr.write(b);
        }
        while ((b = in.read()) >= 0) {
            out.write(b);
        }
        if (oerr.size() > 0) {
            log.info((Object)("Graphviz output to stderr: \n" + oerr.toString()));
        }
        if (out.size() > 0) {
            log.info((Object)("Graphviz output to stdout: \n" + out.toString()));
        }
    }

    protected abstract Props drawObject(Object var1);

    protected String getGraphvizBinary() {
        return "/opt/local/bin/dot";
    }

    protected String id(Object cls) {
        if (cls == null) {
            return null;
        }
        long safeAbsInt = Math.abs((long)cls.hashCode());
        if (cls instanceof EPackage) {
            return "cluster" + safeAbsInt;
        }
        if (cls instanceof EObject) {
            return ((EObject)cls).eClass().getName().toLowerCase() + safeAbsInt;
        }
        return cls.getClass().getSimpleName().toLowerCase() + safeAbsInt;
    }

    protected abstract class Props
    extends HashMap<String, String> {
        private static final long serialVersionUID = 414470084198132521L;

        protected Props() {
        }

        public abstract void draw(PrintStream var1);

        protected String esc(String s) {
            if (noEsc.matcher(s).matches()) {
                return s;
            }
            return "\"" + s.replaceAll("\"|\\[|\\]|>|<|&", "\\\\$0") + "\"";
        }

        public void print(PrintStream out) {
            for (Map.Entry e : this.entrySet()) {
                out.println((String)e.getKey() + "=" + this.esc((String)e.getValue()) + ";");
            }
        }

        public void setLabel(String label) {
            this.put("label", label);
        }

        public void setStyle(String style) {
            this.put("style", style);
        }

        @Override
        public String toString() {
            if (this.size() == 0) {
                return "";
            }
            StringBuffer b = new StringBuffer();
            Iterator i = this.entrySet().iterator();
            Map.Entry e = i.next();
            b.append((String)e.getKey() + "=" + this.esc((String)e.getValue()));
            while (i.hasNext()) {
                e = i.next();
                b.append("," + (String)e.getKey() + "=" + this.esc((String)e.getValue()));
            }
            return b.toString();
        }
    }

    protected class Node
    extends Props {
        private static final long serialVersionUID = 758381202465081606L;
        private Object obj;

        public Node(Object obj) {
            this.obj = obj;
        }

        public Node(Object obj, String label) {
            this(obj);
            this.setLabel(label);
        }

        public Node(Object obj, String label, String shape) {
            this(obj, label);
            this.setShape(shape);
        }

        @Override
        public void draw(PrintStream out) {
            out.println(GraphvizDotBuilder.this.id(this.obj) + " [" + this + "];");
        }

        public void setShape(String shape) {
            this.put("shape", shape);
        }
    }

    protected class Edge
    extends Props {
        private static final long serialVersionUID = 1941409538047058551L;
        private Object dst;
        private Object src;

        public Edge(Object src, Object dst) {
            this.src = src;
            this.dst = dst;
        }

        @Override
        public void draw(PrintStream out) {
            out.println(GraphvizDotBuilder.this.id(this.src) + "->" + GraphvizDotBuilder.this.id(this.dst) + " [" + this + "];");
        }

        public void setNoConstraint() {
            this.put("constraint", "false");
        }
    }

    protected class Digraph
    extends Props {
        private static final long serialVersionUID = -8103262357417982098L;
        private List<Edge> edges = new ArrayList<Edge>();
        private List<Node> nodes = new ArrayList<Node>();

        public void add(Props child) {
            if (child instanceof Node) {
                this.nodes.add((Node)child);
            } else if (child instanceof Edge) {
                this.edges.add((Edge)child);
            } else {
                throw new RuntimeException("Unknown child type");
            }
        }

        @Override
        public void draw(PrintStream out) {
            out.println("digraph G {");
            for (Node n : this.nodes) {
                n.draw(out);
            }
            for (Edge e : this.edges) {
                e.draw(out);
            }
            out.println("}");
            out.println();
        }
    }
}

