/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dartboard.preference;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dartboard.Messages;
import org.eclipse.dartboard.util.StatusUtil;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;

public class DartSDKLocationFieldEditor
extends DirectoryFieldEditor {
    private static final ILog LOG = Platform.getLog(DartSDKLocationFieldEditor.class);

    public DartSDKLocationFieldEditor(String preferencesKey, String label, Composite parent) {
        super(preferencesKey, label, parent);
        this.setValidateStrategy(0);
    }

    protected boolean doCheckState() {
        String location = this.getTextControl().getText();
        boolean isValid = this.isValidDartSDK(location);
        if (!isValid) {
            this.setErrorMessage(Messages.Preference_SDKNotFound_Message);
            this.showErrorMessage();
        }
        return isValid;
    }

    private boolean isValidDartSDK(String location) {
        if (location.isEmpty()) {
            return false;
        }
        boolean isWindows = "win32".equals(Platform.getOS());
        Path path = null;
        try {
            path = Paths.get(location, new String[0]).resolve("bin" + File.separator + (isWindows ? "dart.exe" : "dart"));
        }
        catch (InvalidPathException e) {
            return false;
        }
        ArrayList blacklist = Lists.newArrayList((Object[])new String[]{"/bin/dart", "/usr/bin/dart"});
        if (!Files.exists(path, new LinkOption[0]) || Files.isDirectory(path, new LinkOption[0]) || !isWindows && blacklist.contains(path.toString().toLowerCase())) {
            return false;
        }
        try {
            path = path.toRealPath(new LinkOption[0]);
        }
        catch (IOException e1) {
            LOG.log(StatusUtil.createError("Couldn't follow symlink", e1));
            return false;
        }
        String executablePath = path.toAbsolutePath().toString();
        String[] commands = isWindows ? new String[]{"cmd", "/c", executablePath, "--version"} : new String[]{"/bin/bash", "-c", String.valueOf(executablePath) + " --version"};
        ProcessBuilder processBuilder = new ProcessBuilder(commands);
        processBuilder.redirectErrorStream(true);
        String version = null;
        try {
            Throwable throwable = null;
            Object var10_14 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(processBuilder.start().getInputStream()));){
                version = reader.readLine();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return false;
        }
        return version.startsWith("Dart VM version");
    }

    protected void addModifyListener(ModifyListener listener) {
        this.getTextControl().addModifyListener(listener);
    }
}

