/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.structures.binary.qualified;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.diffmerge.structures.IEqualityTester;
import org.eclipse.emf.diffmerge.structures.binary.qualified.AbstractQBinaryRelation;
import org.eclipse.emf.diffmerge.structures.binary.qualified.IRangedQBinaryRelation;
import org.eclipse.emf.diffmerge.structures.common.FHashSet;

public abstract class AbstractMapQBinaryRelation<T, U, Q>
extends AbstractQBinaryRelation<T, U, Q> {
    public AbstractMapQBinaryRelation() {
        this((IEqualityTester)null);
    }

    public AbstractMapQBinaryRelation(IEqualityTester tester_p) {
        super(tester_p);
    }

    public AbstractMapQBinaryRelation(IRangedQBinaryRelation<T, U, Q> initialContents_p) {
        super(initialContents_p);
    }

    @Override
    public boolean add(T source_p, U target_p, Q qualifier_p) {
        Collection<U> targets = this.prepareAddition(source_p, qualifier_p);
        boolean result = targets.add(target_p);
        return result;
    }

    @Override
    public boolean addAll(T source_p, Collection<? extends U> targets_p, Q qualifier_p) {
        Collection<U> targets = this.prepareAddition(source_p, qualifier_p);
        boolean result = targets.addAll(targets_p);
        return result;
    }

    @Override
    public void clear() {
        this.getContents().clear();
    }

    protected abstract EMap<T, EMap<Q, Collection<U>>> getContents();

    @Override
    public Collection<Q> getQualifiers() {
        FHashSet result = new FHashSet(this.getEqualityTester());
        for (EMap elementData : this.getContents().values()) {
            result.addAll(elementData.keySet());
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Collection<T> getSources() {
        return Collections.unmodifiableSet(this.getContents().keySet());
    }

    @Override
    public Collection<U> getTargets() {
        FHashSet result = new FHashSet(this.getEqualityTester());
        for (EMap sourceData : this.getContents().values()) {
            for (Collection targets : sourceData.values()) {
                result.addAll(targets);
            }
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public Map<Q, Collection<U>> getWithDetails(T element_p) {
        EMap sourceData = (EMap)this.getContents().get(element_p);
        Map result = sourceData != null ? Collections.unmodifiableMap(sourceData.map()) : Collections.emptyMap();
        return result;
    }

    protected abstract EMap<Q, Collection<U>> newSourceData();

    protected abstract Collection<U> newTargetCollection();

    protected Collection<U> prepareAddition(T source_p, Q qualifier_p) {
        Collection<U> targets;
        EMap<Q, Collection<U>> sourceData = (EMap<Q, Collection<U>>)this.getContents().get(source_p);
        if (sourceData == null) {
            sourceData = this.newSourceData();
            this.getContents().put(source_p, sourceData);
        }
        if ((targets = (Collection<U>)sourceData.get(qualifier_p)) == null) {
            targets = this.newTargetCollection();
            sourceData.put(qualifier_p, targets);
        }
        return targets;
    }

    @Override
    public boolean remove(T source_p, U target_p) {
        boolean result = false;
        EMap sourceData = (EMap)this.getContents().get(source_p);
        if (sourceData != null) {
            Iterator entriesIterator = sourceData.entrySet().iterator();
            while (entriesIterator.hasNext()) {
                Map.Entry entry = (Map.Entry)entriesIterator.next();
                Collection targets = (Collection)entry.getValue();
                boolean removed = targets.remove(target_p);
                boolean bl = result = result || removed;
                if (!removed || !targets.isEmpty()) continue;
                entriesIterator.remove();
            }
            if (sourceData.isEmpty()) {
                this.getContents().removeKey(source_p);
            }
        }
        return result;
    }

    @Override
    public boolean remove(T source_p, U target_p, Q qualifier_p) {
        Collection targets;
        boolean result = false;
        EMap sourceData = (EMap)this.getContents().get(source_p);
        if (sourceData != null && (targets = (Collection)sourceData.get(qualifier_p)) != null && (result = targets.remove(target_p)) && targets.isEmpty()) {
            sourceData.removeKey(qualifier_p);
            if (sourceData.isEmpty()) {
                this.getContents().removeKey(source_p);
            }
        }
        return result;
    }

    @Override
    public boolean removeQualifier(Q qualifier_p) {
        boolean result = false;
        Iterator elementIterator = this.getContents().entrySet().iterator();
        while (elementIterator.hasNext()) {
            Map.Entry elementEntry = (Map.Entry)elementIterator.next();
            EMap elementData = (EMap)elementEntry.getValue();
            Object removed = elementData.removeKey(qualifier_p);
            boolean bl = result = result || removed != null;
            if (!elementData.isEmpty()) continue;
            elementIterator.remove();
        }
        return result;
    }

    @Override
    public boolean removeQualifier(T source_p, Q qualifier_p) {
        boolean result = false;
        EMap elementData = (EMap)this.getContents().get(source_p);
        if (elementData != null) {
            Object removed = elementData.removeKey(qualifier_p);
            boolean bl = result = result || removed != null;
            if (elementData.isEmpty()) {
                this.getContents().remove(source_p);
            }
        }
        return result;
    }

    @Override
    public boolean removeSource(T source_p) {
        assert (source_p != null);
        EMap sourceData = (EMap)this.getContents().removeKey(source_p);
        boolean result = sourceData != null;
        return result;
    }

    @Override
    public boolean removeTarget(U target_p) {
        boolean result = false;
        Iterator elementIterator = this.getContents().entrySet().iterator();
        while (elementIterator.hasNext()) {
            Map.Entry elementEntry = (Map.Entry)elementIterator.next();
            Iterator qualifierIterator = ((EMap)elementEntry.getValue()).entrySet().iterator();
            while (qualifierIterator.hasNext()) {
                Map.Entry qualifierEntry = (Map.Entry)qualifierIterator.next();
                Collection targets = (Collection)qualifierEntry.getValue();
                boolean removed = targets.remove(target_p);
                boolean bl = result = result || removed;
                if (!removed || !targets.isEmpty()) continue;
                qualifierIterator.remove();
            }
            if (!((EMap)elementEntry.getValue()).isEmpty()) continue;
            elementIterator.remove();
        }
        return result;
    }
}

