/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.connector.core.ext;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.INavigatable;
import org.eclipse.compare.IPropertyChangeNotifier;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.IFlushable;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.connector.core.EMFDiffMergeCoreConnectorPlugin;
import org.eclipse.emf.diffmerge.connector.core.Messages;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.setup.ComparisonSetup;
import org.eclipse.emf.diffmerge.ui.setup.ComparisonSetupManager;
import org.eclipse.emf.diffmerge.ui.setup.EMFDiffMergeEditorInput;
import org.eclipse.emf.diffmerge.ui.viewers.AbstractComparisonViewer;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class TeamComparisonViewer
extends Viewer
implements IFlushable,
IPropertyChangeNotifier {
    protected final Composite _control;
    protected CompareConfiguration _configuration;
    protected final Collection<IPropertyChangeListener> _pendingListeners;
    protected AbstractComparisonViewer _innerViewer;
    protected Object _input;

    public TeamComparisonViewer(Composite parent_p, CompareConfiguration configuration_p) {
        this._configuration = configuration_p;
        this._control = this.createControl(parent_p);
        this._pendingListeners = new HashSet<IPropertyChangeListener>();
        this._innerViewer = null;
        this._input = null;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener_p) {
        if (this._innerViewer == null && !this._control.isDisposed()) {
            this._pendingListeners.add(listener_p);
        } else {
            this._innerViewer.addPropertyChangeListener(listener_p);
        }
    }

    protected void closeEditor() {
        IEditorPart editor;
        IWorkbenchPage page;
        IWorkbenchWindow activeWorkbenchWindow = EMFDiffMergeUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null && (page = activeWorkbenchWindow.getActivePage()) != null && (editor = page.getActiveEditor()) != null) {
            page.closeEditor(editor, false);
        }
    }

    protected Composite createControl(Composite parent_p) {
        Composite result = new Composite(parent_p, 0);
        result.setData("org.eclipse.compare.CompareUI.CompareViewerTitle", (Object)EMFDiffMergeCoreConnectorPlugin.getDefault().getViewerLabel());
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        result.setLayout((Layout)layout);
        result.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e_p) {
                TeamComparisonViewer.this.handleDispose();
            }
        });
        this.registerNavigatable(result);
        return result;
    }

    protected EMFDiffMergeEditorInput createEditorInput(ComparisonSetupManager manager_p, Object left_p, Object right_p, Object ancestor_p) {
        ComparisonSetup setup = manager_p.createComparisonSetup(left_p, right_p, ancestor_p);
        if (setup != null) {
            setup.setTwoWayReferenceRole(Role.REFERENCE);
            setup.setCanChangeTwoWayReferenceRole(false);
            setup.setCanSwapScopeDefinitions(false);
        }
        return manager_p.createEditorInputWithUI(this.getShell(), setup);
    }

    public void flush(IProgressMonitor monitor_p) {
        if (this._innerViewer != null) {
            this._innerViewer.flush(monitor_p);
        }
    }

    public Control getControl() {
        return this._control;
    }

    public Object getInput() {
        return this._input;
    }

    public ISelection getSelection() {
        return this._innerViewer == null ? null : this._innerViewer.getSelection();
    }

    protected Shell getShell() {
        return this._control.getShell();
    }

    protected void handleDispose() {
        this._configuration = null;
        this._pendingListeners.clear();
        this._innerViewer = null;
        this._input = null;
    }

    public void refresh() {
        if (this._innerViewer != null) {
            this._innerViewer.refresh();
        }
    }

    protected void registerNavigatable(Composite control_p) {
        INavigatable navigatable = new INavigatable(){

            protected INavigatable getDelegate() {
                INavigatable navResult = null;
                if (TeamComparisonViewer.this._innerViewer != null) {
                    navResult = TeamComparisonViewer.this._innerViewer.getNavigatable();
                }
                return navResult;
            }

            public Object getInput() {
                return TeamComparisonViewer.this.getInput();
            }

            public boolean hasChange(int changeFlag_p) {
                boolean result = false;
                INavigatable delegate = this.getDelegate();
                if (delegate != null) {
                    result = delegate.hasChange(changeFlag_p);
                }
                return result;
            }

            public boolean openSelectedChange() {
                boolean result = false;
                INavigatable delegate = this.getDelegate();
                if (delegate != null) {
                    result = delegate.openSelectedChange();
                }
                return result;
            }

            public boolean selectChange(int changeFlag_p) {
                boolean result = false;
                INavigatable delegate = this.getDelegate();
                if (delegate != null) {
                    result = delegate.selectChange(changeFlag_p);
                }
                return result;
            }
        };
        control_p.setData("org.eclipse.compare.internal.Navigator", (Object)navigatable);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener_p) {
        if (this._innerViewer != null) {
            this._innerViewer.removePropertyChangeListener(listener_p);
        } else {
            this._pendingListeners.remove(listener_p);
        }
    }

    public void setInput(Object input_p) {
        block18: {
            if (input_p == this._input) {
                return;
            }
            this._input = input_p;
            if (input_p instanceof EMFDiffNode || input_p == null) {
                if (this._innerViewer != null) {
                    this._innerViewer.setInput(input_p);
                }
            } else if (input_p instanceof ICompareInput) {
                ITypedElement left = ((ICompareInput)input_p).getLeft();
                ITypedElement right = ((ICompareInput)input_p).getRight();
                ITypedElement ancestor = ((ICompareInput)input_p).getAncestor();
                if (right != null && right.equals(ancestor)) {
                    ancestor = null;
                }
                ComparisonSetupManager manager = EMFDiffMergeUIPlugin.getDefault().getSetupManager();
                try {
                    ICompareContainer compareContainer;
                    EMFDiffMergeEditorInput editorInput = this.createEditorInput(manager, left, right, ancestor);
                    if (editorInput == null) break block18;
                    if (this._configuration != null && (compareContainer = this._configuration.getContainer()) != null) {
                        editorInput.setContainer(compareContainer);
                    }
                    try {
                        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
                        dialog.run(true, true, (IRunnableWithProgress)editorInput);
                    }
                    catch (InvocationTargetException e) {
                        EMFDiffMergeCoreConnectorPlugin.getDefault().logError(e);
                    }
                    catch (InterruptedException e) {
                        EMFDiffMergeCoreConnectorPlugin.getDefault().logError(e);
                    }
                    EMFDiffNode compareResult = editorInput.getCompareResult();
                    if (compareResult != null) {
                        Composite innerControl;
                        if (this._innerViewer != null && (innerControl = this._innerViewer.getControl()) != null && !innerControl.isDisposed()) {
                            innerControl.dispose();
                        }
                        Control contents = editorInput.createContents(this._control);
                        GridData layoutData = new GridData(4, 4, true, true);
                        contents.setLayoutData((Object)layoutData);
                        this._innerViewer = editorInput.getViewer();
                        this._control.pack();
                        this._control.getParent().layout();
                        for (IPropertyChangeListener listener : this._pendingListeners) {
                            this._innerViewer.addPropertyChangeListener(listener);
                        }
                        this._pendingListeners.clear();
                    } else {
                        this._innerViewer = null;
                        String message = editorInput.getMessage();
                        if (message == null || message.length() == 0) {
                            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.TeamComparisonViewer_NoDiff_Title, (String)Messages.TeamComparisonViewer_NoDiff_Message);
                        } else {
                            MessageDialog.openError((Shell)this.getShell(), (String)Messages.TeamComparisonViewer_NoDiff_Title, (String)message);
                        }
                        this.closeEditor();
                    }
                }
                catch (IllegalArgumentException e) {
                    manager.handleSetupError(this.getShell(), e.getLocalizedMessage());
                }
            }
        }
    }

    public void setSelection(ISelection selection_p, boolean reveal_p) {
        if (this._innerViewer != null) {
            this._innerViewer.setSelection(selection_p, reveal_p);
        }
    }
}

