/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.parser.builder.event;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.builder.event.DocumentBuilderEvent;

public class LinkEvent
extends DocumentBuilderEvent {
    private final String hrefOrHashName;
    private final String text;
    private final Attributes attributes;

    public LinkEvent(Attributes attributes, String hrefOrHashName, String text) {
        this.attributes = ((Attributes)Preconditions.checkNotNull((Object)attributes, (Object)"Must provide attributes")).clone();
        this.hrefOrHashName = (String)Preconditions.checkNotNull((Object)hrefOrHashName, (Object)"Must provide hrefOrHashName");
        this.text = (String)Preconditions.checkNotNull((Object)text, (Object)"Must provide text");
    }

    @Override
    public void invoke(DocumentBuilder builder) {
        builder.link(this.attributes, this.hrefOrHashName, this.text);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.hrefOrHashName, this.text});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LinkEvent)) {
            return false;
        }
        LinkEvent other = (LinkEvent)obj;
        return Objects.equal((Object)this.hrefOrHashName, (Object)other.hrefOrHashName) && Objects.equal((Object)this.text, (Object)other.text);
    }

    public String toString() {
        return String.format("link(%s,\"%s\")", this.hrefOrHashName, this.text);
    }
}

