/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.jgit.command.ui;

import org.eclipse.dirigible.ide.jgit.command.ui.BaseCommandDialog;
import org.eclipse.dirigible.ide.jgit.command.ui.Messages;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PushCommandDialog
extends BaseCommandDialog {
    private static final long serialVersionUID = -5124345102495879231L;
    private static final String PUSH_CHANGES_TO_REMOTE_GIT_REPOSITORY = Messages.BaseCommandDialog_PUSH_CHANGES_TO_REMOTE_GIT_REPOSITORY;
    private static final String COMMIT_MESSAGE = Messages.CommandDialog_COMMIT_MESSAGE;
    private static final String EMAIL = Messages.PushCommandDialog_EMAIL;
    private static final String COMMIT_MESSAGE_IS_EMPTY = Messages.PushCommandDialog_COMMIT_MESSAGE_IS_EMPTY;
    private static final String EMAIL_IS_EMPTY = Messages.PushCommandDialog_EMAIL_IS_EMPTY;
    private Text textCommitMessage;
    private Text textEmail;
    private String commitMessage;
    private String email;

    public PushCommandDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.setTitle(PUSH_CHANGES_TO_REMOTE_GIT_REPOSITORY);
    }

    @Override
    protected void addWidgets(Composite container) {
        this.createCommitMessageField(container);
        super.addWidgets(container);
        this.createEmailField(container);
    }

    private void createCommitMessageField(Composite container) {
        Label labelCommitMessage = new Label(container, 0);
        labelCommitMessage.setText(COMMIT_MESSAGE);
        GridData dataCommitMessage = new GridData();
        dataCommitMessage.grabExcessHorizontalSpace = true;
        dataCommitMessage.horizontalAlignment = 4;
        this.textCommitMessage = new Text(container, 2048);
        this.textCommitMessage.setLayoutData((Object)dataCommitMessage);
    }

    private void createEmailField(Composite container) {
        Label labelEmail = new Label(container, 0);
        labelEmail.setText(EMAIL);
        GridData dataEmail = new GridData();
        dataEmail.grabExcessHorizontalSpace = true;
        dataEmail.horizontalAlignment = 4;
        this.textEmail = new Text(container, 2048);
        this.textEmail.setLayoutData((Object)dataEmail);
    }

    @Override
    protected boolean validateInput() {
        boolean valid = false;
        if (super.validateInput()) {
            if (StringUtils.isEmptyOrNull((String)this.textCommitMessage.getText())) {
                this.errorMessage = COMMIT_MESSAGE_IS_EMPTY;
            } else if (StringUtils.isEmptyOrNull((String)this.textEmail.getText())) {
                this.errorMessage = EMAIL_IS_EMPTY;
            } else {
                valid = true;
            }
        }
        return valid;
    }

    @Override
    protected void saveInput() {
        super.saveInput();
        this.commitMessage = this.textCommitMessage.getText();
        this.email = this.textEmail.getText();
    }

    public String getCommitMessage() {
        return this.commitMessage;
    }

    public String getEmail() {
        return this.email;
    }
}

