/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.repository.ui.view;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.dirigible.ide.repository.RepositoryFacade;
import org.eclipse.dirigible.ide.repository.ui.view.IRefreshableView;
import org.eclipse.dirigible.ide.repository.ui.view.Messages;
import org.eclipse.dirigible.ide.repository.ui.viewer.RepositoryViewer;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.RepositoryException;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;

public class RepositoryView
extends ViewPart
implements IRefreshableView {
    private static final String COULD_NOT_ACCESS_REPOSITORY = Messages.RepositoryView_COULD_NOT_ACCESS_REPOSITORY;
    private static final String OPERATION_FAILED = Messages.RepositoryView_OPERATION_FAILED;
    private static final Logger logger = Logger.getLogger(RepositoryView.class);
    private static final String DOT = ". ";
    private static final String COLON = ": ";
    private static final String CHECK_LOGS_FOR_MORE_INFO = Messages.RepositoryView_CHECK_LOGS_FOR_MORE_INFO;
    private static final String COULD_NOT_EXECUTE_OPEN_COMMAND_DUE_TO_THE_FOLLOWING_ERROR = Messages.RepositoryView_COULD_NOT_EXECUTE_OPEN_COMMAND_DUE_TO_THE_FOLLOWING_ERROR;
    public static final String ID = "org.eclipse.dirigible.ide.repository.ui.view.RepositoryView";
    private static final String OPEN_COMMAND_ID = "org.eclipse.dirigible.ide.repository.ui.command.OpenHandler";
    private IRepository repository;
    private RepositoryViewer viewer;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        try {
            this.repository = RepositoryFacade.getInstance().getRepository();
        }
        catch (RepositoryException ex) {
            throw new PartInitException(COULD_NOT_ACCESS_REPOSITORY, (Throwable)ex);
        }
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.viewer = new RepositoryViewer(parent, 2);
        this.viewer.setRepository(this.repository);
        this.viewer.getTreeViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                RepositoryView.this.onWorkspaceViewerDoubleClicked(event);
            }
        });
        this.getSite().setSelectionProvider(this.viewer.getSelectionProvider());
        this.getSite().registerContextMenu("menu.repository", this.viewer.getMenuManager(), this.viewer.getSelectionProvider());
    }

    private void onWorkspaceViewerDoubleClicked(DoubleClickEvent event) {
        ICommandService commandService = (ICommandService)this.getSite().getService(ICommandService.class);
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        Command command = commandService.getCommand(OPEN_COMMAND_ID);
        ExecutionEvent executionEvent = handlerService.createExecutionEvent(command, null);
        try {
            command.executeWithChecks(executionEvent);
        }
        catch (Exception ex) {
            logger.error(COULD_NOT_EXECUTE_OPEN_COMMAND_DUE_TO_THE_FOLLOWING_ERROR, (Throwable)ex);
            MessageDialog.openError(null, (String)OPERATION_FAILED, (String)(String.valueOf(COULD_NOT_EXECUTE_OPEN_COMMAND_DUE_TO_THE_FOLLOWING_ERROR) + COLON + ex.getMessage() + DOT + CHECK_LOGS_FOR_MORE_INFO));
        }
    }

    @Override
    public void refresh() {
        if (this.viewer != null) {
            this.viewer.refresh();
        }
    }

    public void setFocus() {
        if (this.viewer != null) {
            this.viewer.setFocus();
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(IRefreshableView.class)) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public void dispose() {
        this.viewer = null;
        super.dispose();
    }
}

