/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.registry;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public abstract class IDERegistryReader {
    private static final String UNKNOWN_EXTENSION_TAG_FOUND_S = "Unknown extension tag found: %s";
    private static final String REQUIRED_SUB_ELEMENT_S_NOT_DEFINED = "Required sub element '%s' not defined";
    private static final String REQUIRED_ATTRIBUTE_S_NOT_DEFINED = "Required attribute '%s' not defined";
    private static final String PLUGIN_S_EXTENSION_S = "Plugin %s, extension %s";
    protected static final String TAG_DESCRIPTION = "description";
    protected static Hashtable<String, IExtension[]> extensionPoints = new Hashtable();
    private static final Comparator<IExtension> comparer = new Comparator<IExtension>(){

        @Override
        public int compare(IExtension arg0, IExtension arg1) {
            IExtension i1 = arg0;
            String s1 = i1.getNamespace();
            IExtension i2 = arg1;
            String s2 = i2.getNamespace();
            return s1.compareToIgnoreCase(s2);
        }
    };

    protected IDERegistryReader() {
    }

    protected String getDescription(IConfigurationElement config) {
        IConfigurationElement[] children = config.getChildren(TAG_DESCRIPTION);
        if (children.length >= 1) {
            return children[0].getValue();
        }
        return "";
    }

    protected void logError(IConfigurationElement element, String text) {
        IExtension extension = element.getDeclaringExtension();
        String pluginId = extension.getNamespace();
        StringBuffer buf = new StringBuffer();
        buf.append(String.format(PLUGIN_S_EXTENSION_S, pluginId, extension.getExtensionPointUniqueIdentifier()));
        buf.append("\n" + text);
        IDEWorkbenchPlugin.log(buf.toString());
    }

    protected void logMissingAttribute(IConfigurationElement element, String attributeName) {
        this.logError(element, String.format(REQUIRED_ATTRIBUTE_S_NOT_DEFINED, attributeName));
    }

    protected void logMissingElement(IConfigurationElement element, String elementName) {
        this.logError(element, String.format(REQUIRED_SUB_ELEMENT_S_NOT_DEFINED, elementName));
    }

    protected void logUnknownElement(IConfigurationElement element) {
        this.logError(element, String.format(UNKNOWN_EXTENSION_TAG_FOUND_S, element.getName()));
    }

    protected IExtension[] orderExtensions(IExtension[] extensions) {
        IExtension[] sortedExtension = new IExtension[extensions.length];
        System.arraycopy(extensions, 0, sortedExtension, 0, extensions.length);
        Collections.sort(Arrays.asList(sortedExtension), comparer);
        return sortedExtension;
    }

    protected abstract boolean readElement(IConfigurationElement var1);

    protected void readElementChildren(IConfigurationElement element) {
        this.readElements(element.getChildren());
    }

    protected void readElements(IConfigurationElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            if (!this.readElement(elements[i])) {
                this.logUnknownElement(elements[i]);
            }
            ++i;
        }
    }

    protected void readExtension(IExtension extension) {
        this.readElements(extension.getConfigurationElements());
    }

    protected void readRegistry(IExtensionRegistry registry, String pluginId, String extensionPoint) {
        String pointId = String.valueOf(pluginId) + "-" + extensionPoint;
        IExtension[] extensions = extensionPoints.get(pointId);
        if (extensions == null) {
            IExtensionPoint point = registry.getExtensionPoint(pluginId, extensionPoint);
            if (point == null) {
                return;
            }
            extensions = point.getExtensions();
            extensions = this.orderExtensions(extensions);
            extensionPoints.put(pointId, extensions);
        }
        int i = 0;
        while (i < extensions.length) {
            this.readExtension(extensions[i]);
            ++i;
        }
    }
}

