/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IMarkerHelpRegistry;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.ide.registry.MarkerQuery;
import org.eclipse.ui.internal.ide.registry.MarkerQueryResult;

public class MarkerHelpRegistry
implements IMarkerHelpRegistry {
    private Map<MarkerQuery, Map> helpQueries = new HashMap<MarkerQuery, Map>();
    private List<MarkerQuery> sortedHelpQueries;
    private Map<MarkerQuery, Map> resolutionQueries = new LinkedHashMap<MarkerQuery, Map>();
    private static final String ATT_HELP = "helpContextId";
    private static final String ATT_CLASS = "class";

    @Override
    public String getHelp(IMarker marker) {
        if (this.sortedHelpQueries == null) {
            Set<MarkerQuery> set = this.helpQueries.keySet();
            this.sortedHelpQueries = new ArrayList<MarkerQuery>(set.size());
            this.sortedHelpQueries.addAll(set);
            Collections.sort(this.sortedHelpQueries, new QueryComparator());
        }
        for (MarkerQuery query : this.sortedHelpQueries) {
            Iterator elements;
            Map resultsTable;
            MarkerQueryResult result = query.performQuery(marker);
            if (result == null || !(resultsTable = this.helpQueries.get(query)).containsKey(result) || !(elements = ((Collection)resultsTable.get(result)).iterator()).hasNext()) continue;
            IConfigurationElement element = (IConfigurationElement)elements.next();
            return element.getAttribute(ATT_HELP);
        }
        return null;
    }

    @Override
    public boolean hasResolutions(IMarker marker) {
        for (MarkerQuery query : this.resolutionQueries.keySet()) {
            Map resultsTable;
            MarkerQueryResult result = query.performQuery(marker);
            if (result == null || !(resultsTable = this.resolutionQueries.get(query)).containsKey(result)) continue;
            for (IConfigurationElement element : (Collection)resultsTable.get(result)) {
                if (!this.hasResolution(marker, element)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasResolution(IMarker marker, IConfigurationElement element) {
        IMarkerResolutionGenerator generator = null;
        if (Platform.getBundle((String)element.getNamespace()).getState() == 32) {
            IMarkerResolution[] resolutions;
            try {
                generator = (IMarkerResolutionGenerator)element.createExecutableExtension(ATT_CLASS);
            }
            catch (CoreException e) {
                Policy.handle(e);
            }
            return generator != null && (generator instanceof IMarkerResolutionGenerator2 ? ((IMarkerResolutionGenerator2)generator).hasResolutions(marker) : (resolutions = generator.getResolutions(marker)).length > 0);
        }
        return true;
    }

    @Override
    public IMarkerResolution[] getResolutions(IMarker marker) {
        ArrayList<IMarkerResolution> resolutions = new ArrayList<IMarkerResolution>();
        for (Map.Entry<MarkerQuery, Map> entry : this.resolutionQueries.entrySet()) {
            Map resultsTable;
            MarkerQuery query = entry.getKey();
            MarkerQueryResult result = query.performQuery(marker);
            if (result == null || !(resultsTable = entry.getValue()).containsKey(result)) continue;
            for (IConfigurationElement element : (Collection)resultsTable.get(result)) {
                IMarkerResolutionGenerator generator = null;
                try {
                    generator = (IMarkerResolutionGenerator)element.createExecutableExtension(ATT_CLASS);
                }
                catch (CoreException e) {
                    Policy.handle(e);
                }
                if (generator == null) continue;
                IMarkerResolution[] generatedResolutions = generator.getResolutions(marker);
                int i = 0;
                while (i < generatedResolutions.length) {
                    resolutions.add(generatedResolutions[i]);
                    ++i;
                }
            }
        }
        return resolutions.toArray(new IMarkerResolution[resolutions.size()]);
    }

    public void addHelpQuery(MarkerQuery query, MarkerQueryResult result, IConfigurationElement element) {
        this.addQuery(this.helpQueries, query, result, element);
    }

    public void addResolutionQuery(MarkerQuery query, MarkerQueryResult result, IConfigurationElement element) {
        this.addQuery(this.resolutionQueries, query, result, element);
    }

    private void addQuery(Map<MarkerQuery, Map> table, MarkerQuery query, MarkerQueryResult result, IConfigurationElement element) {
        HashMap results = table.get(query);
        if (results == null) {
            results = new HashMap();
            table.put(query, results);
        }
        if (results.containsKey(result)) {
            Collection currentElements = (Collection)results.get(result);
            currentElements.add(element);
        } else {
            HashSet<IConfigurationElement> elements = new HashSet<IConfigurationElement>();
            elements.add(element);
            results.put(result, elements);
        }
    }

    private class QueryComparator
    implements Comparator<Object> {
        private QueryComparator() {
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof QueryComparator;
        }

        public int hashCode() {
            return QueryComparator.class.hashCode();
        }

        @Override
        public int compare(Object o1, Object o2) {
            int size2;
            MarkerQuery q1 = (MarkerQuery)o1;
            MarkerQuery q2 = (MarkerQuery)o2;
            int size1 = q1.getAttributes().length;
            if (size1 > (size2 = q2.getAttributes().length)) {
                return -1;
            }
            if (size1 == size2) {
                return 0;
            }
            return 1;
        }
    }
}

