/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.messaging;

import javax.servlet.ServletException;
import javax.sql.DataSource;
import org.eclipse.dirigible.repository.ext.messaging.MessageHub;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.repository.RepositoryFacade;

public class MessagingSynchronizer
implements Runnable {
    private static final Logger logger = Logger.getLogger(MessagingSynchronizer.class);

    @Override
    public void run() {
        logger.debug("entering: " + this.getClass().getCanonicalName() + " -> " + "run");
        try {
            this.routeMessages();
            logger.debug("Routing of Messages was successful");
        }
        catch (Exception e) {
            logger.error("Routing of Messages failed.", (Throwable)e);
        }
        logger.debug("exiting: " + this.getClass().getCanonicalName() + " -> " + "run");
    }

    private void routeMessages() throws ServletException {
        try {
            DataSource dataSource = RepositoryFacade.getInstance().getDataSource();
            MessageHub messageHub = new MessageHub(dataSource, null);
            messageHub.route();
            messageHub.cleanup();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }
}

