/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.java.dynamic.compilation;

import java.io.File;
import java.io.IOException;
import java.security.SecureClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import org.eclipse.dirigible.repository.api.IEntityInformation;
import org.eclipse.dirigible.runtime.java.dynamic.compilation.JavaClassObject;
import org.eclipse.dirigible.runtime.scripting.Module;

public class ClassFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    private static final String DOT = ".";
    private static final String SLASH = "/";
    private static final String PATH_SEPARATOR = "path.separator";
    private static final String separator = System.getProperty("path.separator");
    private static ClassFileManager instance;
    private static final Map<String, JavaFileObject> lastKnownSourceFiles;

    static {
        lastKnownSourceFiles = Collections.synchronizedMap(new HashMap());
    }

    public static synchronized ClassFileManager getInstance(StandardJavaFileManager standardManager) {
        if (instance == null) {
            instance = new ClassFileManager(standardManager);
        }
        return new ClassFileManager(standardManager);
    }

    public static String getFQN(String module) {
        int indexOf;
        StringBuilder fqn = new StringBuilder(module);
        if (fqn.charAt(0) == SLASH.charAt(0)) {
            fqn.delete(0, 1);
        }
        if ((indexOf = fqn.indexOf(DOT)) > 0) {
            fqn.delete(indexOf, fqn.length());
        }
        return fqn.toString().replace(SLASH, DOT);
    }

    public static String getJars(File libDirectory) throws IOException {
        StringBuilder jars = new StringBuilder();
        if (libDirectory == null) {
            throw new IOException("Lib directory is null");
        }
        if (!libDirectory.exists()) {
            throw new IOException(String.format("File %s does not exist", libDirectory.getCanonicalFile()));
        }
        File[] fileArray = libDirectory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File jar = fileArray[n2];
            String jarPath = jar.getCanonicalPath();
            if (jar.isFile()) {
                if (!jarPath.contains(".source_") && jarPath.endsWith(".jar")) {
                    jars.append(String.valueOf(jarPath) + separator);
                }
            } else {
                jars.append(ClassFileManager.getJars(jar));
            }
            ++n2;
        }
        return jars.toString();
    }

    public static JavaFileObject getSourceFile(String className) {
        return lastKnownSourceFiles.get(className);
    }

    public static List<JavaFileObject> getSourceFiles(List<Module> modules) throws IOException {
        for (Module module : modules) {
            String fqn = ClassFileManager.getFQN(module.getName());
            long lastModified = ClassFileManager.getLastModified(module);
            JavaClassObject lastKnownSoruceFile = (JavaClassObject)ClassFileManager.getSourceFile(fqn);
            if (lastKnownSoruceFile != null && lastKnownSoruceFile.getLastModified() >= lastModified) continue;
            String content = new String(module.getContent());
            lastKnownSourceFiles.put(fqn, new JavaClassObject(fqn, JavaFileObject.Kind.SOURCE, content, lastModified));
        }
        JavaFileObject[] array = lastKnownSourceFiles.values().toArray(new JavaFileObject[0]);
        return Arrays.asList(array);
    }

    private static long getLastModified(Module module) {
        Date lastModified = null;
        IEntityInformation entityInformation = module.getEntityInformation();
        lastModified = entityInformation != null ? entityInformation.getModifiedAt() : new Date();
        return lastModified.getTime();
    }

    private ClassFileManager(StandardJavaFileManager standardManager) {
        super(standardManager);
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return new SecureClassLoader(ClassLoader.getSystemClassLoader()){

            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                Class<?> clazz = null;
                JavaClassObject javaClassObject = (JavaClassObject)lastKnownSourceFiles.get(name);
                if (javaClassObject != null) {
                    byte[] bytes = javaClassObject.getBytes();
                    clazz = super.defineClass(name, bytes, 0, bytes.length);
                } else {
                    clazz = Servlet.class.getClassLoader().loadClass(name);
                }
                return clazz;
            }
        };
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        return lastKnownSourceFiles.get(className);
    }
}

