/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.shared.editor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dirigible.ide.shared.editor.Messages;

public class EditorUtil {
    private static final String COULD_NOT_FIND_EXTENSION_POINT = Messages.EditorUtil_COULD_NOT_FIND_EXTENSION_POINT;
    private static final String EDITOR_EXTENSION_POINT_ID = "org.eclipse.ui.editors";

    public static String getEditorIdForExtension(String extension) {
        IExtension[] extensions;
        IExtensionPoint extensionPoint = EditorUtil.getExtensionPoint(EDITOR_EXTENSION_POINT_ID);
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] editorElements;
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] elements = ext.getConfigurationElements();
            IConfigurationElement[] iConfigurationElementArray = editorElements = EditorUtil.getConfigurationElements(elements, "editor");
            int n3 = editorElements.length;
            int n4 = 0;
            while (n4 < n3) {
                String idAttribute;
                Set<String> values;
                IConfigurationElement editorElement = iConfigurationElementArray[n4];
                String extensionsAttribute = editorElement.getAttribute("extensions");
                if (extensionsAttribute != null && (values = EditorUtil.getValues(extensionsAttribute)).contains(extension) && (idAttribute = editorElement.getAttribute("id")) != null) {
                    return idAttribute;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    private static Set<String> getValues(String attribute) {
        HashSet<String> result = new HashSet<String>();
        EditorUtil.extractValues(attribute, result);
        return result;
    }

    private static void extractValues(String text, Set<String> result) {
        if (text == null) {
            return;
        }
        int commaIndex = text.indexOf(44);
        if (commaIndex != -1) {
            String value = text.substring(0, commaIndex);
            result.add(value);
            EditorUtil.extractValues(text.substring(commaIndex + 1), result);
        } else {
            result.add(text);
        }
    }

    private static IConfigurationElement[] getConfigurationElements(IConfigurationElement[] elements, String name) {
        ArrayList<IConfigurationElement> result = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (name.equals(element.getName())) {
                result.add(element);
            }
            ++n2;
        }
        return result.toArray(new IConfigurationElement[0]);
    }

    private static IExtensionPoint getExtensionPoint(String id) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint result = registry.getExtensionPoint(id);
        if (result == null) {
            throw new RuntimeException(String.valueOf(COULD_NOT_FIND_EXTENSION_POINT) + id);
        }
        return result;
    }
}

