/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.sc.wizard;

import org.eclipse.core.resources.IResource;
import org.eclipse.dirigible.ide.common.status.StatusLineManagerUtil;
import org.eclipse.dirigible.ide.template.ui.common.GenerationModel;
import org.eclipse.dirigible.ide.template.ui.common.TemplateGenerator;
import org.eclipse.dirigible.ide.template.ui.common.TemplateWizard;
import org.eclipse.dirigible.ide.template.ui.sc.wizard.Messages;
import org.eclipse.dirigible.ide.template.ui.sc.wizard.SecurityConstraintTemplateGenerator;
import org.eclipse.dirigible.ide.template.ui.sc.wizard.SecurityConstraintTemplateModel;
import org.eclipse.dirigible.ide.template.ui.sc.wizard.SecurityConstraintTemplateTargetLocationPage;
import org.eclipse.dirigible.ide.template.ui.sc.wizard.SecurityConstraintTemplateTypePage;
import org.eclipse.jface.wizard.IWizardPage;

public class SecurityConstraintTemplateWizard
extends TemplateWizard {
    private static final String CREATE_ACCESS_FILE = Messages.SecurityConstraintTemplateWizard_CREATE_ACCESS_FILE;
    private final SecurityConstraintTemplateModel model;
    private final SecurityConstraintTemplateTypePage typesPage;
    private final SecurityConstraintTemplateTargetLocationPage targetLocationPage;

    public SecurityConstraintTemplateWizard(IResource resource) {
        this.setWindowTitle(CREATE_ACCESS_FILE);
        this.model = new SecurityConstraintTemplateModel();
        this.model.setSourceResource(resource);
        this.typesPage = new SecurityConstraintTemplateTypePage(this.model);
        this.targetLocationPage = new SecurityConstraintTemplateTargetLocationPage(this.model);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.typesPage);
        this.addPage((IWizardPage)this.targetLocationPage);
    }

    public TemplateGenerator getTemplateGenerator() {
        SecurityConstraintTemplateGenerator generator = new SecurityConstraintTemplateGenerator(this.model);
        return generator;
    }

    protected GenerationModel getModel() {
        return this.model;
    }

    protected String openEditorForFileWithExtension() {
        return "access";
    }

    public boolean performFinish() {
        boolean result = super.performFinish();
        if (result) {
            StatusLineManagerUtil.setInfoMessage((String)String.format(StatusLineManagerUtil.ARTIFACT_HAS_BEEN_CREATED, this.model.getFileName()));
        }
        return result;
    }
}

