/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.dirigible.ide.workspace.RemoteResourcesPlugin;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;

public class WorkbenchContentProvider
extends BaseWorkbenchContentProvider
implements IResourceChangeListener {
    private static final long serialVersionUID = -593700356567302056L;
    private Viewer viewer;

    public void dispose() {
        if (this.viewer != null) {
            RemoteResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }
        super.dispose();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        if (this.viewer == null) {
            RemoteResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        }
        this.viewer = viewer;
    }

    public final void resourceChanged(IResourceChangeEvent event) {
        this.processDelta(event.getDelta());
    }

    protected void processDelta(IResourceDelta delta) {
        Control ctrl = this.viewer.getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        final ArrayList<Runnable> runnables = new ArrayList<Runnable>();
        this.processDelta(delta, runnables);
        if (runnables.isEmpty()) {
            return;
        }
        if (ctrl.getDisplay().getThread() == Thread.currentThread()) {
            this.runUpdates(runnables);
        } else {
            ctrl.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Control ctrl = WorkbenchContentProvider.this.viewer.getControl();
                    if (ctrl == null || ctrl.isDisposed()) {
                        return;
                    }
                    WorkbenchContentProvider.this.runUpdates(runnables);
                }
            });
        }
    }

    private void runUpdates(Collection<Runnable> runnables) {
        Iterator<Runnable> runnableIterator = runnables.iterator();
        while (runnableIterator.hasNext()) {
            runnableIterator.next().run();
        }
    }

    private void processDelta(IResourceDelta delta, Collection<Runnable> runnables) {
        Object[] removedObjects;
        int i;
        Object[] addedObjects;
        Control ctrl = this.viewer.getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        final IResource resource = delta.getResource();
        IResourceDelta[] affectedChildren = delta.getAffectedChildren(4);
        int i2 = 0;
        while (i2 < affectedChildren.length) {
            if ((affectedChildren[i2].getFlags() & 0x8000) != 0) {
                runnables.add(this.getRefreshRunnable(resource));
                return;
            }
            ++i2;
        }
        int changeFlags = delta.getFlags();
        if ((changeFlags & 0x4000) != 0) {
            if (resource.isAccessible()) {
                runnables.add(this.getUpdateRunnable(resource));
            } else {
                runnables.add(this.getRefreshRunnable(resource));
                return;
            }
        }
        if ((changeFlags & 0x98000) != 0) {
            runnables.add(this.getUpdateRunnable(resource));
        }
        if ((changeFlags & 0x40000) != 0) {
            runnables.add(this.getRefreshRunnable(resource));
            return;
        }
        int i3 = 0;
        while (i3 < affectedChildren.length) {
            this.processDelta(affectedChildren[i3], runnables);
            ++i3;
        }
        IResourceDelta[] addedChildren = delta.getAffectedChildren(1);
        IResourceDelta[] removedChildren = delta.getAffectedChildren(2);
        if (addedChildren.length == 0 && removedChildren.length == 0) {
            return;
        }
        int numMovedFrom = 0;
        int numMovedTo = 0;
        if (addedChildren.length > 0) {
            addedObjects = new Object[addedChildren.length];
            i = 0;
            while (i < addedChildren.length) {
                addedObjects[i] = addedChildren[i].getResource();
                if ((addedChildren[i].getFlags() & 0x1000) != 0) {
                    ++numMovedFrom;
                }
                ++i;
            }
        } else {
            addedObjects = new Object[]{};
        }
        if (removedChildren.length > 0) {
            removedObjects = new Object[removedChildren.length];
            i = 0;
            while (i < removedChildren.length) {
                removedObjects[i] = removedChildren[i].getResource();
                if ((removedChildren[i].getFlags() & 0x2000) != 0) {
                    ++numMovedTo;
                }
                ++i;
            }
        } else {
            removedObjects = new Object[]{};
        }
        final boolean hasRename = numMovedFrom > 0 && numMovedTo > 0;
        Runnable addAndRemove = new Runnable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                if (WorkbenchContentProvider.this.viewer instanceof AbstractTreeViewer) {
                    AbstractTreeViewer treeViewer = (AbstractTreeViewer)WorkbenchContentProvider.this.viewer;
                    if (hasRename) {
                        treeViewer.getControl().setRedraw(false);
                    }
                    try {
                        if (addedObjects.length > 0) {
                            treeViewer.add((Object)resource, addedObjects);
                        }
                        if (removedObjects.length <= 0) return;
                        treeViewer.remove(removedObjects);
                        return;
                    }
                    finally {
                        if (hasRename) {
                            treeViewer.getControl().setRedraw(true);
                        }
                    }
                } else {
                    ((StructuredViewer)WorkbenchContentProvider.this.viewer).refresh((Object)resource);
                }
            }
        };
        runnables.add(addAndRemove);
    }

    private Runnable getRefreshRunnable(final IResource resource) {
        return new Runnable(){

            @Override
            public void run() {
                ((StructuredViewer)WorkbenchContentProvider.this.viewer).refresh((Object)resource);
            }
        };
    }

    private Runnable getUpdateRunnable(final IResource resource) {
        return new Runnable(){

            @Override
            public void run() {
                ((StructuredViewer)WorkbenchContentProvider.this.viewer).update((Object)resource, null);
            }
        };
    }
}

