/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dirigible.ide.workspace.RemoteResourcesPlugin;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.part.FileEditorInput;

public class FileEditorInputFactory
implements IElementFactory {
    private static final String ID_FACTORY = "org.eclipse.ui.part.FileEditorInputFactory";
    private static final String TAG_PATH = "path";

    public IAdaptable createElement(IMemento memento) {
        String fileName = memento.getString(TAG_PATH);
        if (fileName == null) {
            return null;
        }
        IWorkspaceRoot root = RemoteResourcesPlugin.getWorkspace().getRoot();
        IFile file = root.getFile((IPath)new Path(fileName));
        if (file != null) {
            return new FileEditorInput(file);
        }
        return null;
    }

    public static String getFactoryId() {
        return ID_FACTORY;
    }

    public static void saveState(IMemento memento, FileEditorInput input) {
        IFile file = input.getFile();
        memento.putString(TAG_PATH, file.getFullPath().toString());
    }
}

