/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.java;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.java.JavaExecutor;
import org.eclipse.dirigible.runtime.java.dynamic.compilation.ClassFileManager;
import org.eclipse.dirigible.runtime.scripting.AbstractScriptingServlet;

public class JavaServlet
extends AbstractScriptingServlet {
    private static final long serialVersionUID = -2029496922201773270L;
    private static final Logger logger = Logger.getLogger(JavaServlet.class);
    private File libDirectory;
    private static String classpath;

    public void init() throws ServletException {
        super.init();
        String eclipseLauncherProperty = System.getProperty("osgi.syspath");
        logger.debug("osgi.syspath: " + eclipseLauncherProperty);
        if (eclipseLauncherProperty == null) {
            eclipseLauncherProperty = System.getProperty("user.dir");
            logger.debug("user.dir: " + eclipseLauncherProperty);
        }
        eclipseLauncherProperty = eclipseLauncherProperty.replace("/./", "/");
        this.libDirectory = new File(eclipseLauncherProperty);
        if (this.libDirectory.exists() && this.libDirectory.getParentFile() != null && this.libDirectory.getParentFile().exists()) {
            this.libDirectory = this.libDirectory.getParentFile();
        }
        try {
            this.getClasspath();
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void doExecution(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String module = request.getPathInfo();
        JavaExecutor executor = this.createExecutor(request);
        HashMap executionContext = new HashMap();
        try {
            Object result = executor.executeServiceModule(request, response, module, executionContext);
            if (result != null) {
                logger.error(result.toString());
                response.sendError(405, result.toString());
            }
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            response.sendError(500, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getClasspath() throws IOException {
        Class<JavaServlet> clazz = JavaServlet.class;
        synchronized (JavaServlet.class) {
            if (classpath == null) {
                if (this.libDirectory != null) {
                    classpath = ClassFileManager.getJars(this.libDirectory);
                } else {
                    try {
                        classpath = ClassFileManager.getJars(new File(Platform.getInstallLocation().getURL().toURI()));
                    }
                    catch (URISyntaxException e) {
                        throw new IOException(e);
                    }
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return classpath;
        }
    }

    public JavaExecutor createExecutor(HttpServletRequest request) throws IOException {
        JavaExecutor executor = new JavaExecutor(this.getRepository(request), this.getClasspath(), this.getScriptingRegistryPath(request), "/db/dirigible/registry/public/ScriptingServices");
        return executor;
    }
}

