/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.logging;

import java.util.logging.Level;
import org.slf4j.LoggerFactory;

public class Logger {
    private static final String LOG_IN_SYSTEM_OUTPUT = "logInSystemOutput";
    private static final String DISABLE_LOGGING = "disableLogging";
    private static final boolean LOGGING_DISABLED = Logger.isLoggingDisabled();
    private final org.slf4j.Logger logger1;
    private final java.util.logging.Logger logger2;

    private static boolean isLoggingDisabled() {
        String disableLogging = System.getProperty(DISABLE_LOGGING);
        return disableLogging != null && Boolean.valueOf(disableLogging) != false;
    }

    private static boolean isLoggingInSystemOutputEnabled() {
        String logInSystemOutput = System.getProperty(LOG_IN_SYSTEM_OUTPUT);
        return logInSystemOutput != null && Boolean.valueOf(logInSystemOutput) != false;
    }

    public static Logger getLogger(String name) {
        return new Logger(LoggerFactory.getLogger((String)name), java.util.logging.Logger.getLogger(name));
    }

    public static Logger getLogger(Class<?> clazz) {
        return new Logger(LoggerFactory.getLogger(clazz), java.util.logging.Logger.getLogger(clazz.getCanonicalName()));
    }

    public Logger(org.slf4j.Logger logger1, java.util.logging.Logger logger2) {
        this.logger1 = logger1;
        this.logger2 = logger2;
    }

    public void error(String message) {
        this.error(message, null);
    }

    public void error(String message, Throwable t) {
        if (this.isErrorEnabled()) {
            this.logger1.error(message, t);
            this.logger2.log(Level.SEVERE, message, t);
        }
        this.logInSystemOutput(message, t);
    }

    public void warn(String message) {
        this.warn(message, null);
    }

    public void warn(String message, Throwable t) {
        if (this.isWarnEnabled()) {
            this.logger1.warn(message, t);
            this.logger2.log(Level.WARNING, message, t);
        }
        this.logInSystemOutput(message, t);
    }

    public void info(String message) {
        this.info(message, null);
    }

    public void info(String message, Throwable t) {
        if (this.isInfoEnabled()) {
            this.logger1.info(message, t);
            this.logger2.log(Level.INFO, message, t);
        }
        this.logInSystemOutput(message, t);
    }

    public void debug(String message) {
        this.debug(message, null);
    }

    public void debug(String message, Throwable t) {
        if (this.isDebugEnabled()) {
            this.logger1.debug(message, t);
            this.logger2.log(Level.FINE, message, t);
        }
        this.logInSystemOutput(message, t);
    }

    public void trace(String message) {
        this.trace(message, null);
    }

    public void trace(String message, Throwable t) {
        if (this.isTraceEnabled()) {
            this.logger1.trace(message, t);
            this.logger2.log(Level.FINE, message, t);
        }
        this.logInSystemOutput(message, t);
    }

    public boolean isErrorEnabled() {
        return this.logger1.isErrorEnabled() || this.logger2.isLoggable(Level.SEVERE);
    }

    public boolean isDebugEnabled() {
        return !LOGGING_DISABLED && (this.logger1.isDebugEnabled() || this.logger2.isLoggable(Level.FINE));
    }

    public boolean isWarnEnabled() {
        return !LOGGING_DISABLED && (this.logger1.isWarnEnabled() || this.logger2.isLoggable(Level.WARNING));
    }

    public boolean isInfoEnabled() {
        return !LOGGING_DISABLED && (this.logger1.isInfoEnabled() || this.logger2.isLoggable(Level.INFO));
    }

    public boolean isTraceEnabled() {
        return !LOGGING_DISABLED && (this.logger1.isTraceEnabled() || this.logger2.isLoggable(Level.FINE));
    }

    private void logInSystemOutput(String message, Throwable t) {
        if (Logger.isLoggingInSystemOutputEnabled()) {
            System.err.println(message);
            if (t != null) {
                t.printStackTrace();
            }
        }
    }
}

