/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.flow;

import java.io.InputStream;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.flow.log.FlowLogCleanupTask;
import org.eclipse.dirigible.runtime.job.log.JobLogCleanupTask;
import org.eclipse.dirigible.runtime.listener.log.ListenerLogCleanupTask;
import org.eclipse.dirigible.runtime.listener.message.MessageListenerTask;
import org.eclipse.dirigible.runtime.task.IRunnableTask;
import org.eclipse.dirigible.runtime.task.TaskManagerLong;
import org.eclipse.dirigible.runtime.task.TaskManagerMedium;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.quartz.Scheduler;
import org.quartz.impl.StdSchedulerFactory;

public class FlowsActivator
implements BundleActivator {
    private static final Logger logger = Logger.getLogger(FlowsActivator.class);
    private static final String SCHEDULER_NAME = "org.eclipse.dirigible.runtime.flow-QuartzScheduler";
    private static BundleContext context;

    public void start(BundleContext context) throws Exception {
        FlowsActivator.context = context;
        FlowLogCleanupTask flowLogCleanupTask = new FlowLogCleanupTask();
        TaskManagerLong.getInstance().registerRunnableTask((IRunnableTask)flowLogCleanupTask);
        JobLogCleanupTask jobLogCleanupTask = new JobLogCleanupTask();
        TaskManagerLong.getInstance().registerRunnableTask((IRunnableTask)jobLogCleanupTask);
        ListenerLogCleanupTask listenerLogCleanupTask = new ListenerLogCleanupTask();
        TaskManagerLong.getInstance().registerRunnableTask((IRunnableTask)listenerLogCleanupTask);
        MessageListenerTask messageListenerTask = new MessageListenerTask();
        TaskManagerMedium.getInstance().registerRunnableTask((IRunnableTask)messageListenerTask);
    }

    public void stop(BundleContext context) throws Exception {
        InputStream schedulerConfig = FlowsActivator.class.getResourceAsStream("/scheduler.properties");
        try {
            StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
            schedulerFactory.initialize(schedulerConfig);
            Scheduler scheduler = schedulerFactory.getScheduler(SCHEDULER_NAME);
            if (scheduler != null) {
                scheduler.shutdown();
            }
        }
        finally {
            block10: {
                if (schedulerConfig != null) {
                    try {
                        schedulerConfig.close();
                    }
                    catch (Exception exception) {
                        if (!logger.isErrorEnabled()) break block10;
                        logger.error("Cannot close the stream to the scheduler configuration.", (Throwable)exception);
                    }
                }
            }
        }
    }

    public static BundleContext getContext() {
        return context;
    }
}

