/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.derby.client.ClientPooledConnection;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.LogicalConnection40;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.StatementCacheInteractor;
import org.apache.derby.client.am.stmtcache.JDBCStatementCache;

public class CachingLogicalConnection40
extends LogicalConnection40 {
    private StatementCacheInteractor cacheInteractor;

    public CachingLogicalConnection40(Connection connection, ClientPooledConnection clientPooledConnection, JDBCStatementCache jDBCStatementCache) throws SqlException {
        super(connection, clientPooledConnection);
        this.cacheInteractor = new StatementCacheInteractor(jDBCStatementCache, connection);
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.cacheInteractor != null) {
            this.cacheInteractor.closeOpenLogicalStatements();
            this.cacheInteractor = null;
            super.close();
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string) throws SQLException {
        this.checkForNullPhysicalConnection();
        return this.cacheInteractor.prepareStatement(string);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.checkForNullPhysicalConnection();
        return this.cacheInteractor.prepareStatement(string, n, n2);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.checkForNullPhysicalConnection();
        return this.cacheInteractor.prepareStatement(string, n, n2, n3);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, int n) throws SQLException {
        this.checkForNullPhysicalConnection();
        return this.cacheInteractor.prepareStatement(string, n);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        this.checkForNullPhysicalConnection();
        PreparedStatement preparedStatement = null;
        if (nArray != null && nArray.length > 1) {
            preparedStatement = super.prepareStatement(string, nArray);
        } else {
            int n = 1;
            if (nArray == null || nArray.length == 0) {
                n = 2;
            }
            preparedStatement = this.cacheInteractor.prepareStatement(string, n);
        }
        return preparedStatement;
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        this.checkForNullPhysicalConnection();
        PreparedStatement preparedStatement = null;
        if (stringArray != null && stringArray.length > 1) {
            preparedStatement = super.prepareStatement(string, stringArray);
        } else {
            int n = 1;
            if (stringArray == null || stringArray.length == 0) {
                n = 2;
            }
            preparedStatement = this.cacheInteractor.prepareStatement(string, n);
        }
        return preparedStatement;
    }

    @Override
    public synchronized CallableStatement prepareCall(String string) throws SQLException {
        this.checkForNullPhysicalConnection();
        return this.cacheInteractor.prepareCall(string);
    }

    @Override
    public synchronized CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.checkForNullPhysicalConnection();
        return this.cacheInteractor.prepareCall(string, n, n2);
    }

    @Override
    public synchronized CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this.checkForNullPhysicalConnection();
        return this.cacheInteractor.prepareCall(string, n, n2, n3);
    }
}

