/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.testfixture.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.Operation;
import org.eclipse.rap.rwt.internal.protocol.RequestMessage;
import org.eclipse.swt.widgets.Widget;

public class TestMessage
extends RequestMessage {
    public TestMessage() {
        super(new JsonObject(), new ArrayList());
    }

    public TestMessage(JsonObject json) {
        super(json);
    }

    public int getRequestCounter() {
        return this.getHead().get("requestCounter").asInt();
    }

    public int getOperationCount() {
        return this.getOperations().size();
    }

    public Operation getOperation(int position) {
        return (Operation)this.getOperations().get(position);
    }

    public JsonValue findSetProperty(Widget widget, String property) {
        return this.findSetProperty(WidgetUtil.getId((Widget)widget), property);
    }

    public JsonValue findSetProperty(String target, String property) {
        Operation.SetOperation operation = this.findSetOperation(target, property);
        if (operation == null) {
            throw new IllegalStateException("operation not found");
        }
        return operation.getProperties().get(property);
    }

    public Operation.SetOperation findSetOperation(Widget widget, String property) {
        return this.findSetOperation(WidgetUtil.getId((Widget)widget), property);
    }

    public Operation.ListenOperation findListenOperation(Widget widget, String property) {
        return this.findListenOperation(WidgetUtil.getId((Widget)widget), property);
    }

    public Operation.ListenOperation findListenOperation(String target, String property) {
        Operation.ListenOperation result = null;
        for (Operation operation : this.getOperations()) {
            if (!(operation instanceof Operation.ListenOperation) || !operation.getTarget().equals(target)) continue;
            Operation.ListenOperation listenOperation = (Operation.ListenOperation)operation;
            if (property != null && listenOperation.getProperties().get(property) == null) continue;
            result = listenOperation;
        }
        return result;
    }

    public JsonValue findListenProperty(Widget widget, String property) {
        return this.findListenProperty(WidgetUtil.getId((Widget)widget), property);
    }

    public JsonValue findListenProperty(String target, String property) {
        Operation.ListenOperation operation = this.findListenOperation(target, property);
        if (operation == null) {
            throw new IllegalStateException("operation not found");
        }
        return operation.getProperties().get(property);
    }

    public Operation.CreateOperation findCreateOperation(Widget widget) {
        return this.findCreateOperation(WidgetUtil.getId((Widget)widget));
    }

    public JsonValue findCreateProperty(Widget widget, String property) {
        return this.findCreateProperty(WidgetUtil.getId((Widget)widget), property);
    }

    public JsonValue findCreateProperty(String target, String property) {
        Operation.CreateOperation operation = this.findCreateOperation(target);
        if (operation == null || !operation.getProperties().names().contains(property)) {
            throw new IllegalStateException("operation not found");
        }
        return operation.getProperties().get(property);
    }

    public Operation.CreateOperation findCreateOperation(String target) {
        Operation.CreateOperation result = null;
        for (Operation operation : this.getOperations()) {
            Operation.CreateOperation createOperation;
            if (!(operation instanceof Operation.CreateOperation) || !operation.getTarget().equals(target)) continue;
            result = createOperation = (Operation.CreateOperation)operation;
        }
        return result;
    }

    public Operation.DestroyOperation findDestroyOperation(Widget widget) {
        Operation.DestroyOperation result = null;
        String target = WidgetUtil.getId((Widget)widget);
        for (Operation operation : this.getOperations()) {
            Operation.DestroyOperation destroyOperation;
            if (!(operation instanceof Operation.DestroyOperation) || !operation.getTarget().equals(target)) continue;
            result = destroyOperation = (Operation.DestroyOperation)operation;
        }
        return result;
    }

    public Operation.SetOperation findSetOperation(String target, String property) {
        Operation.SetOperation result = null;
        for (Operation operation : this.getOperations()) {
            if (!(operation instanceof Operation.SetOperation) || !operation.getTarget().equals(target)) continue;
            Operation.SetOperation setOperation = (Operation.SetOperation)operation;
            if (property != null && setOperation.getProperties().get(property) == null) continue;
            result = setOperation;
        }
        return result;
    }

    public Operation.CallOperation findCallOperation(Widget widget, String method) {
        return this.findCallOperation(WidgetUtil.getId((Widget)widget), method);
    }

    public Operation.CallOperation findCallOperation(String target, String method) {
        Operation.CallOperation result = null;
        List operations = this.getOperations();
        for (Operation operation : operations) {
            if (!operation.getTarget().equals(target) || !(operation instanceof Operation.CallOperation) || !method.equals(((Operation.CallOperation)operation).getMethodName())) continue;
            result = (Operation.CallOperation)operation;
        }
        return result;
    }

    public static String getParent(Operation.CreateOperation operation) {
        JsonValue value = operation.getProperties().get("parent");
        return value == null ? null : value.asString();
    }

    public static List<String> getStyles(Operation.CreateOperation operation) {
        JsonValue value = operation.getProperties().get("style");
        if (value == null) {
            return null;
        }
        JsonArray styles = value.asArray();
        ArrayList<String> result = new ArrayList<String>(styles.size());
        for (JsonValue style : styles) {
            result.add(style.asString());
        }
        return result;
    }
}

