/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.repository.ui.viewer;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.dirigible.ide.repository.ui.viewer.Messages;
import org.eclipse.dirigible.ide.repository.ui.viewer.RepositoryViewerResolveNode;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IEntity;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ArtifactTreeContentProvider
implements ITreeContentProvider {
    private static final long serialVersionUID = 5108751356542487531L;
    private static final String COULD_NOT_CHECK_IF_COLLECTION_HAS_CHILDREN = Messages.ArtifactTreeContentProvider_COULD_NOT_CHECK_IF_COLLECTION_HAS_CHILDREN;
    private static final String ERROR_CLICK_TO_RETRY = Messages.ArtifactTreeContentProvider_ERROR_CLICK_TO_RETRY;
    private static final String COULD_NOT_RESOLVE_COLLECTION_S_CHILDREN = Messages.ArtifactTreeContentProvider_COULD_NOT_RESOLVE_COLLECTION_S_CHILDREN;
    private static final Logger log = Logger.getLogger((String)ArtifactTreeContentProvider.class.getCanonicalName());

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof Object[]) {
            return (Object[])inputElement;
        }
        return null;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ICollection) {
            return this.getCollectionChildren((ICollection)parentElement);
        }
        return new Object[0];
    }

    private Object[] getCollectionChildren(ICollection collection) {
        try {
            ArrayList children = new ArrayList();
            children.addAll(collection.getCollections());
            children.addAll(collection.getResources());
            return children.toArray();
        }
        catch (IOException ex) {
            log.error(COULD_NOT_RESOLVE_COLLECTION_S_CHILDREN);
            log.error(ArtifactTreeContentProvider.class.getCanonicalName(), (Throwable)ex);
            return new Object[]{new RepositoryViewerResolveNode(collection, ERROR_CLICK_TO_RETRY)};
        }
    }

    public Object getParent(Object element) {
        if (element instanceof IEntity) {
            return this.getEntityParent((IEntity)element);
        }
        if (element instanceof RepositoryViewerResolveNode) {
            return this.getResolveNodeParent((RepositoryViewerResolveNode)element);
        }
        return null;
    }

    private Object getEntityParent(IEntity entity) {
        return entity.getParent();
    }

    private Object getResolveNodeParent(RepositoryViewerResolveNode node) {
        return node.getParent();
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IEntity) {
            return this.entityHasChildren((IEntity)element);
        }
        return false;
    }

    private boolean entityHasChildren(IEntity entity) {
        if (entity instanceof ICollection) {
            return this.collectionHasChildren((ICollection)entity);
        }
        return false;
    }

    private boolean collectionHasChildren(ICollection collection) {
        try {
            return !collection.isEmpty();
        }
        catch (IOException ex) {
            log.error(COULD_NOT_CHECK_IF_COLLECTION_HAS_CHILDREN);
            log.error(ArtifactTreeContentProvider.class.getCanonicalName(), (Throwable)ex);
            return true;
        }
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

