/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.bridge;

import java.io.IOException;
import javax.naming.InitialContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.ide.bridge.IInjector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitialContextInjector
implements IInjector {
    private static final Logger logger = LoggerFactory.getLogger(InitialContextInjector.class);
    public static final String INITIAL_CONTEXT = "InitialContext";

    @Override
    public void injectOnRequest(ServletConfig servletConfig, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        InitialContext initialContext = (InitialContext)req.getSession().getAttribute(INITIAL_CONTEXT);
        if (initialContext == null) {
            try {
                initialContext = new InitialContext();
                req.getSession().setAttribute(INITIAL_CONTEXT, (Object)initialContext);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void injectOnStart(ServletConfig servletConfig) {
        InitialContext initialContext = (InitialContext)System.getProperties().get(INITIAL_CONTEXT);
        if (initialContext == null) {
            try {
                initialContext = new InitialContext();
                System.getProperties().put(INITIAL_CONTEXT, initialContext);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

