/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.db.viewer.views.actions;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.dirigible.ide.db.viewer.views.IDatabaseConnectionFactory;
import org.eclipse.dirigible.ide.db.viewer.views.TableDefinition;
import org.eclipse.dirigible.ide.db.viewer.views.TreeObject;
import org.eclipse.dirigible.ide.db.viewer.views.TreeParent;
import org.eclipse.dirigible.ide.db.viewer.views.actions.Messages;
import org.eclipse.dirigible.ide.db.viewer.views.actions.RefreshViewAction;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;

public class DeleteTableAction
extends Action {
    private static final String DROP_TABLE = "DROP TABLE ";
    private static final String DATABASE_VIEW = Messages.DeleteTableAction_DATABASE_VIEW;
    private static final String FAILED_TO_DELETE_TABLE_S = Messages.DeleteTableAction_FAILED_TO_DELETE_TABLE_S;
    private static final Logger logger = Logger.getLogger(DeleteTableAction.class);
    private static final String WARNING_THIS_ACTION_WILL_DELETE_THE_TABLE_AND_ALL_OF_ITS_CONTENT_CONTINUE = Messages.DeleteTableAction_WARNING_THIS_ACTION_WILL_DELETE_THE_TABLE_AND_ALL_OF_ITS_CONTENT_CONTINUE;
    private static final String WILL_DELETE_THE_TABLE_AND_ITS_CONTENT = Messages.DeleteTableAction_WILL_DELETE_THE_TABLE_AND_ITS_CONTENT;
    private static final String DELETE_TABLE = Messages.DeleteTableAction_DELETE_TABLE;
    private static final long serialVersionUID = 3872859942737870851L;
    private TreeViewer viewer;

    public DeleteTableAction(TreeViewer viewer) {
        this.viewer = viewer;
        this.setText(DELETE_TABLE);
        this.setToolTipText(WILL_DELETE_THE_TABLE_AND_ITS_CONTENT);
    }

    public void run() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        TreeParent parent = null;
        for (Object obj : selection) {
            if (!TreeObject.class.isInstance(obj) || ((TreeObject)obj).getTableDefinition() == null) continue;
            TableDefinition tableDefinition = ((TreeObject)obj).getTableDefinition();
            boolean confirm = MessageDialog.openConfirm((Shell)this.viewer.getControl().getShell(), (String)DELETE_TABLE, (String)String.format(WARNING_THIS_ACTION_WILL_DELETE_THE_TABLE_AND_ALL_OF_ITS_CONTENT_CONTINUE, tableDefinition.getTableName()));
            if (!confirm) continue;
            parent = ((TreeObject)obj).getParent();
            IDatabaseConnectionFactory connectionFactory = parent.getConnectionFactory();
            try {
                this.deleteTable(tableDefinition, connectionFactory);
            }
            catch (SQLException e) {
                this.showMessage(String.format(FAILED_TO_DELETE_TABLE_S, tableDefinition.getTableName()));
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (parent != null) {
            RefreshViewAction refresh = new RefreshViewAction(this.viewer, parent.getChildren()[0]);
            refresh.run();
        }
    }

    protected void showMessage(String message) {
        MessageDialog.openError((Shell)this.viewer.getControl().getShell(), (String)DATABASE_VIEW, (String)message);
    }

    private void deleteTable(TableDefinition tableDefinition, IDatabaseConnectionFactory connectionFactory) throws SQLException {
        Connection connection = connectionFactory.getDatabaseConnection();
        try {
            Statement createStatement = connection.createStatement();
            String name = tableDefinition.getFqn();
            createStatement.execute(DROP_TABLE + name);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }
}

