/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.db.viewer.views.format;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.dirigible.ide.db.viewer.views.format.ColumnDescriptor;
import org.eclipse.dirigible.ide.db.viewer.views.format.HeaderFormatter;
import org.eclipse.dirigible.ide.db.viewer.views.format.Messages;
import org.eclipse.dirigible.ide.db.viewer.views.format.ResultSetWriter;
import org.eclipse.dirigible.ide.db.viewer.views.format.RowFormatter;
import org.eclipse.dirigible.ide.db.viewer.views.format.StringHeaderFormatter;
import org.eclipse.dirigible.ide.db.viewer.views.format.StringRowFormatter;

public class ResultSetStringWriter
implements ResultSetWriter<String> {
    private static final String EMPTY_RESULT_SET = Messages.ResultSetStringWriter_EMPTY_RESULT_SET;
    public static final String DELIMITER = "|";
    public static final String NEWLINE_CHARACTER = System.getProperty("line.separator");
    private HeaderFormatter<?> headerFormat = new StringHeaderFormatter();
    private RowFormatter<?> rowFormat = new StringRowFormatter();

    @Override
    public String writeTable(ResultSet resultSet) throws SQLException {
        StringBuilder tableSb = new StringBuilder();
        ArrayList<ColumnDescriptor> columnHeaderDescriptors = new ArrayList<ColumnDescriptor>();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int count = 0;
        while (resultSet.next()) {
            resultSetMetaData = resultSet.getMetaData();
            List<String> headersForRow = this.getHeader(resultSetMetaData);
            for (String headerForRow : headersForRow) {
                ColumnDescriptor colDescr = new ColumnDescriptor();
                colDescr.setName(headerForRow);
                int colindex = this.getColumIndexByName(colDescr.getName(), resultSetMetaData);
                colDescr.setLabel(resultSetMetaData.getColumnLabel(colindex));
                if (colDescr.getLabel() == null) {
                    colDescr.setLabel(colDescr.getName());
                }
                colDescr.setSqlType(resultSetMetaData.getColumnType(colindex));
                int displaySize = resultSetMetaData.getColumnDisplaySize(colindex);
                if (displaySize > 256) {
                    displaySize = 256;
                }
                colDescr.setDisplaySize(displaySize);
                if (colDescr.getDisplaySize() < colDescr.getName().length()) {
                    colDescr.setDisplaySize(colDescr.getName().length());
                }
                if (columnHeaderDescriptors.contains(colDescr)) continue;
                columnHeaderDescriptors.add(colDescr);
            }
            tableSb.append(this.rowFormat.write(columnHeaderDescriptors, resultSetMetaData, resultSet));
            if (++count <= 100) continue;
            tableSb.append("...");
            break;
        }
        if (columnHeaderDescriptors.size() > 0) {
            String headers = (String)this.headerFormat.write(columnHeaderDescriptors);
            tableSb.insert(0, headers);
        } else {
            tableSb.append(EMPTY_RESULT_SET);
        }
        return tableSb.toString();
    }

    int getColumIndexByName(String columnName, ResultSetMetaData metadata) throws SQLException {
        int i = 1;
        while (i < metadata.getColumnCount() + 1) {
            if (columnName.equals(metadata.getColumnName(i))) {
                return i;
            }
            ++i;
        }
        return Integer.MIN_VALUE;
    }

    List<String> getHeader(ResultSetMetaData resultSetMetaData) throws SQLException {
        ArrayList<String> columHeaderLables = new ArrayList<String>();
        int i = 1;
        while (i <= resultSetMetaData.getColumnCount()) {
            String columnHeaderLabel = resultSetMetaData.getColumnLabel(i);
            columHeaderLables.add(columnHeaderLabel);
            ++i;
        }
        return columHeaderLables;
    }

    public HeaderFormatter<?> getHeaderFormat() {
        return this.headerFormat;
    }

    public void setHeaderFormat(HeaderFormatter<?> headerFormat) {
        this.headerFormat = headerFormat;
    }

    public RowFormatter<?> getRowFormat() {
        return this.rowFormat;
    }

    public void setRowFormat(RowFormatter<?> rowFormat) {
        this.rowFormat = rowFormat;
    }
}

