/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.jgit.command.ui;

import org.eclipse.dirigible.ide.jgit.command.ui.BaseCommandDialog;
import org.eclipse.dirigible.ide.jgit.command.ui.Messages;
import org.eclipse.dirigible.ide.jgit.utils.GitFileUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CloneCommandDialog
extends BaseCommandDialog {
    private static final long serialVersionUID = -5124345102495879231L;
    private static final String CLONING_GIT_REPOSITORY = Messages.CloneCommandDialog_CLONING_GIT_REPOSITORY;
    private static final String ENTER_GIT_REPOSITORY_URL = Messages.CloneCommandDialog_ENTER_GIT_REPOSITORY_URL;
    private static final String INVALID_GIT_REPOSITORY_URL = Messages.CloneCommandDialog_INVALID_GIT_REPOSITORY_URL;
    private static final String REPOSITORY_URI = Messages.CommandDialog_REPOSITORY_URI;
    private Text textRepositoryURI;
    private String repositoryURI;

    public CloneCommandDialog(Shell parentShell, String git) {
        super(parentShell);
        this.repositoryURI = git;
    }

    public void create() {
        super.create();
        this.setTitle(CLONING_GIT_REPOSITORY);
        this.setMessage(ENTER_GIT_REPOSITORY_URL);
    }

    @Override
    protected void addWidgets(Composite container) {
        this.createRepositoryURIField(container);
        super.addWidgets(container);
    }

    private void createRepositoryURIField(Composite container) {
        Label labelRepositoryURI = new Label(container, 0);
        labelRepositoryURI.setText(REPOSITORY_URI);
        GridData dataRepositoryURI = new GridData();
        dataRepositoryURI.grabExcessHorizontalSpace = true;
        dataRepositoryURI.horizontalAlignment = 4;
        this.textRepositoryURI = new Text(container, 2048);
        this.textRepositoryURI.setLayoutData((Object)dataRepositoryURI);
        if (this.repositoryURI != null) {
            this.textRepositoryURI.setText(this.repositoryURI);
        }
    }

    @Override
    protected boolean validateInput() {
        boolean valid = GitFileUtils.isValidRepositoryURI(this.textRepositoryURI.getText());
        if (!valid) {
            this.errorMessage = INVALID_GIT_REPOSITORY_URL;
        }
        return valid;
    }

    @Override
    protected void saveInput() {
        super.saveInput();
        this.repositoryURI = this.textRepositoryURI.getText();
    }

    public String getRepositoryURI() {
        return this.repositoryURI;
    }
}

