/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.registry;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IResource;

public class DefinitionEnumerator {
    private final List<String> list = new ArrayList<String>();

    public DefinitionEnumerator(String repositoryPath, ICollection collection, String fileExtension) throws IOException {
        this.enumerateJsDefinitions(repositoryPath, collection, fileExtension);
    }

    public List<String> toArrayList() {
        return this.list;
    }

    private void enumerateJsDefinitions(String repositoryPath, ICollection collection, String fileExtension) throws IOException {
        if (collection.exists()) {
            for (IResource resource : collection.getResources()) {
                String collecationPath;
                if (resource == null || resource.getName() == null || !resource.getName().endsWith(fileExtension) || (collecationPath = collection.getPath()).length() < repositoryPath.length()) continue;
                String fullPath = String.valueOf(collecationPath.substring(repositoryPath.length())) + "/" + resource.getName();
                this.list.add(fullPath);
            }
            for (ICollection subCollection : collection.getCollections()) {
                this.enumerateJsDefinitions(repositoryPath, subCollection, fileExtension);
            }
        }
    }
}

