/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.task;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.task.IRunnableTask;

public abstract class TaskManager
implements Runnable {
    private static final Logger logger = Logger.getLogger(TaskManager.class);
    private List<IRunnableTask> runnableTasks = Collections.synchronizedList(new ArrayList());
    private List<IRunnableTask> forRemove = Collections.synchronizedList(new ArrayList());

    @Override
    public void run() {
        logger.debug("entering: " + this.getClass().getCanonicalName() + " -> " + "run");
        try {
            this.startRunnableTasks();
            logger.debug("All tasks were performed successfylly: " + this.runnableTasks.size());
        }
        catch (Exception e) {
            logger.error("Task Manager error", (Throwable)e);
        }
        logger.debug("exiting: " + this.getClass().getCanonicalName() + " -> " + "run");
    }

    public void registerRunnableTask(IRunnableTask runnableTask) {
        logger.debug("entering: " + this.getClass().getCanonicalName() + " -> " + "registerRunnableTask");
        this.runnableTasks.add(runnableTask);
        logger.debug("registered runnable task: " + runnableTask.getName());
        logger.debug("exiting: " + this.getClass().getCanonicalName() + " -> " + "registerRunnableTask");
    }

    public void unregisterRunnableTask(IRunnableTask runnableTask) {
        logger.debug("entering: " + this.getClass().getCanonicalName() + " -> " + "unregisterRunnableTask");
        this.forRemove.add(runnableTask);
        logger.debug("unregistered runnable task: " + runnableTask.getName());
        logger.debug("exiting: " + this.getClass().getCanonicalName() + " -> " + "unregisterRunnableTask");
    }

    private void removeRunnableTask(IRunnableTask runnableTask) {
        logger.debug("entering: " + this.getClass().getCanonicalName() + " -> " + "removeRunnableTask");
        this.runnableTasks.remove(runnableTask);
        logger.debug("unregistered runnable task: " + runnableTask.getName());
        logger.debug("exiting: " + this.getClass().getCanonicalName() + " -> " + "removeRunnableTask");
    }

    private void startRunnableTasks() throws ServletException {
        for (IRunnableTask runnableTask : this.forRemove) {
            this.removeRunnableTask(runnableTask);
        }
        for (IRunnableTask task : this.runnableTasks) {
            try {
                logger.debug("Staring Task: " + task.getName() + "...");
                task.start();
                logger.debug("Task: " + task.getName() + " - " + "ended.");
            }
            catch (Exception e) {
                logger.error("Task Manager error for Task: " + task.getName(), (Throwable)e);
            }
        }
    }
}

