/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.javascript.rhino;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.lang.javascript.rhino.BundleProxyClassLoader;
import org.eclipse.ease.lang.javascript.rhino.RhinoScriptEngine;

public class RhinoClassLoader
extends BundleProxyClassLoader {
    private static Map<IScriptEngine, URLClassLoader> REGISTERED_JARS = new HashMap<IScriptEngine, URLClassLoader>();
    private static RhinoClassLoader fInstance = null;
    private final Collection<URLClassLoader> fTraversingURLClassLoader = new HashSet<URLClassLoader>();

    public static RhinoClassLoader getInstance() {
        if (fInstance == null) {
            fInstance = new RhinoClassLoader();
        }
        return fInstance;
    }

    private RhinoClassLoader() {
        super(Platform.getBundle((String)"org.mozilla.javascript"), RhinoClassLoader.class.getClassLoader());
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        Job currentJob = Job.getJobManager().currentJob();
        URLClassLoader classLoader = REGISTERED_JARS.get(currentJob);
        if (classLoader != null && !this.fTraversingURLClassLoader.contains(classLoader)) {
            this.fTraversingURLClassLoader.add(classLoader);
            try {
                Class<?> clazz = classLoader.loadClass(name);
                if (clazz != null) {
                    Class<?> clazz2 = clazz;
                    return clazz2;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            finally {
                this.fTraversingURLClassLoader.remove(classLoader);
            }
        }
        return super.findClass(name);
    }

    public static void registerURL(IScriptEngine engine, URL url) {
        if (!REGISTERED_JARS.containsKey(engine)) {
            REGISTERED_JARS.put(engine, URLClassLoader.newInstance(new URL[]{url}, RhinoClassLoader.getInstance()));
        } else {
            URL[] registeredURLs = REGISTERED_JARS.get(engine).getURLs();
            List<URL> urlList = Arrays.asList(registeredURLs);
            if (!urlList.contains(url)) {
                URL[] updatedURLs = Arrays.copyOf(registeredURLs, registeredURLs.length + 1);
                updatedURLs[updatedURLs.length - 1] = url;
                REGISTERED_JARS.put(engine, URLClassLoader.newInstance(updatedURLs, RhinoClassLoader.getInstance()));
            }
        }
    }

    public static void unregisterEngine(RhinoScriptEngine engine) {
        REGISTERED_JARS.remove((Object)engine);
    }
}

