/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.modules.ui;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.ease.modules.ModuleHelper;
import org.eclipse.ease.ui.tools.AbstractVirtualTreeProvider;

public class ModulesContentProvider
extends AbstractVirtualTreeProvider {
    private final boolean mModulesOnly;

    public ModulesContentProvider(boolean modulesOnly) {
        this.mModulesOnly = modulesOnly;
    }

    @Override
    public Object getParent(Object element) {
        return null;
    }

    @Override
    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ModuleDefinition && !this.mModulesOnly) {
            ArrayList children = new ArrayList();
            children.addAll(ModuleHelper.getFields((Class)((ModuleDefinition)parentElement).getModuleClass()));
            children.addAll(ModuleHelper.getMethods((Class)((ModuleDefinition)parentElement).getModuleClass()));
            return children.toArray();
        }
        return super.getChildren(parentElement);
    }

    @Override
    protected void populateElements(Object inputElement) {
        if (inputElement instanceof Collection) {
            for (Object module : (Collection)inputElement) {
                if (!(module instanceof ModuleDefinition)) continue;
                this.registerElement(((ModuleDefinition)module).getPath().removeLastSegments(1), module);
            }
        }
    }

    @Override
    public boolean hasChildren(Object element) {
        if (element instanceof ModuleDefinition && !this.mModulesOnly) {
            boolean hasChildren = false;
            Class clazz = ((ModuleDefinition)element).getModuleClass();
            if (clazz == null) {
                return false;
            }
            hasChildren |= !ModuleHelper.getMethods((Class)clazz).isEmpty();
            return hasChildren |= !ModuleHelper.getFields((Class)clazz).isEmpty();
        }
        return super.hasChildren(element);
    }
}

