/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.help.hovers;

import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.ease.ui.help.hovers.HelpHoverImageProvider;
import org.eclipse.ease.ui.help.hovers.IHoverHelp;
import org.eclipse.ui.IMemento;

public class ConstantHelp
implements IHoverHelp {
    private final URL fHelpLocation;
    private final IMemento fHelpContent;
    private final Field fField;

    public ConstantHelp(URL helpLocation, IMemento helpContent, Field field) {
        this.fHelpLocation = helpLocation;
        this.fHelpContent = helpContent;
        this.fField = field;
    }

    @Override
    public String getName() {
        return this.fField.getName();
    }

    @Override
    public String getDescription() {
        IMemento descriptionNode = this.getDescriptionNode();
        if (descriptionNode != null) {
            String content = IHoverHelp.getNodeContent(descriptionNode);
            IMemento warningNode = this.getWarningNode(descriptionNode);
            if (warningNode != null) {
                content = content.replace(IHoverHelp.getNodeContent(warningNode), "");
                content = content.replace("<div class=\"warning\"></div>", "");
            }
            return content;
        }
        return "";
    }

    private String getDeprecationMessage() {
        IMemento descriptionNode = this.getDescriptionNode();
        if (descriptionNode != null) {
            IMemento warningNode = this.getWarningNode(descriptionNode);
            return IHoverHelp.getNodeContent(warningNode);
        }
        return null;
    }

    private IMemento getWarningNode(IMemento descriptionNode) {
        IMemento warningNode = descriptionNode.getChild("div");
        if (warningNode != null && "warning".equals(warningNode.getString("class"))) {
            return warningNode;
        }
        return null;
    }

    private IMemento getDescriptionNode() {
        IMemento[] iMementoArray = this.fHelpContent.getChildren();
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento node = iMementoArray[n2];
            if ("constants".equals(node.getString("class"))) {
                ArrayList<IMemento> candidates = new ArrayList<IMemento>();
                candidates.addAll(Arrays.asList(node.getChildren()));
                while (!candidates.isEmpty()) {
                    IMemento candidate = (IMemento)candidates.remove(0);
                    if (this.fField.getName().equals(candidate.getString("data-field"))) {
                        IHoverHelp.updateRelativeLinks(candidate, this.fHelpLocation);
                        return candidate;
                    }
                    candidates.addAll(Arrays.asList(candidate.getChildren()));
                }
                break;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public String getHoverContent() {
        String description;
        StringBuffer help = new StringBuffer();
        help.append("<h5>");
        help.append(IHoverHelp.getImageAndLabel(HelpHoverImageProvider.getImageLocation("icons/eobj16/field.png"), this.getName()));
        help.append("</h5>");
        String deprecationMessage = this.getDeprecationMessage();
        if (!deprecationMessage.isEmpty()) {
            help.append("<p>");
            help.append(deprecationMessage);
            help.append("</p>");
        }
        if (!(description = this.getDescription()).isEmpty()) {
            help.append("<p>");
            help.append(description);
            help.append("</p>");
        }
        return help.toString();
    }
}

