/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.unittest.definition.impl;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ease.lang.unittest.definition.Flag;
import org.eclipse.ease.lang.unittest.definition.ICode;
import org.eclipse.ease.lang.unittest.definition.IDefinitionFactory;
import org.eclipse.ease.lang.unittest.definition.IDefinitionPackage;
import org.eclipse.ease.lang.unittest.definition.ITestSuiteDefinition;
import org.eclipse.ease.lang.unittest.definition.IVariable;
import org.eclipse.ease.lang.unittest.definition.impl.FlagToStringMap;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.InternalEList;

public class TestSuiteDefinition
extends MinimalEObjectImpl.Container
implements ITestSuiteDefinition {
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected static final String DESCRIPTION_EDEFAULT = null;
    protected String description = DESCRIPTION_EDEFAULT;
    protected static final String INCLUDE_FILTER_EDEFAULT = "";
    protected String includeFilter = "";
    protected static final String EXCLUDE_FILTER_EDEFAULT = "";
    protected String excludeFilter = "";
    protected EList<IPath> disabledResources;
    protected EList<IVariable> variables;
    protected EList<ICode> customCode;
    protected EMap<Flag, String> flags;
    protected static final String VERSION_EDEFAULT = "";
    protected String version = "";
    protected static final Object RESOURCE_EDEFAULT = null;
    protected Object resource = RESOURCE_EDEFAULT;

    protected TestSuiteDefinition() {
    }

    protected EClass eStaticClass() {
        return IDefinitionPackage.Literals.TEST_SUITE_DEFINITION;
    }

    public String getNameGen() {
        return this.name;
    }

    @Override
    public String getName() {
        String definitionName = this.getNameGen();
        if (definitionName != null) {
            return definitionName;
        }
        if (this.getResource() instanceof IFile) {
            return ((IFile)this.getResource()).getName();
        }
        if (this.getResource() instanceof File) {
            return ((File)this.getResource()).getName();
        }
        return null;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String newDescription) {
        String oldDescription = this.description;
        this.description = newDescription;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldDescription, (Object)this.description));
        }
    }

    @Override
    public String getIncludeFilter() {
        return this.includeFilter;
    }

    @Override
    public void setIncludeFilter(String newIncludeFilter) {
        String oldIncludeFilter = this.includeFilter;
        this.includeFilter = newIncludeFilter;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldIncludeFilter, (Object)this.includeFilter));
        }
    }

    @Override
    public String getExcludeFilter() {
        return this.excludeFilter;
    }

    @Override
    public void setExcludeFilter(String newExcludeFilter) {
        String oldExcludeFilter = this.excludeFilter;
        this.excludeFilter = newExcludeFilter;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldExcludeFilter, (Object)this.excludeFilter));
        }
    }

    @Override
    public EList<IPath> getDisabledResources() {
        if (this.disabledResources == null) {
            this.disabledResources = new EDataTypeUniqueEList(IPath.class, (InternalEObject)this, 4);
        }
        return this.disabledResources;
    }

    @Override
    public EList<IVariable> getVariables() {
        if (this.variables == null) {
            this.variables = new EObjectContainmentEList(IVariable.class, (InternalEObject)this, 5);
        }
        return this.variables;
    }

    @Override
    public EList<ICode> getCustomCode() {
        if (this.customCode == null) {
            this.customCode = new EObjectContainmentEList(ICode.class, (InternalEObject)this, 6);
        }
        return this.customCode;
    }

    @Override
    public EMap<Flag, String> getFlags() {
        if (this.flags == null) {
            this.flags = new EcoreEMap(IDefinitionPackage.Literals.FLAG_TO_STRING_MAP, FlagToStringMap.class, (InternalEObject)this, 7);
        }
        return this.flags;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String newVersion) {
        String oldVersion = this.version;
        this.version = newVersion;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldVersion, (Object)this.version));
        }
    }

    @Override
    public Object getResource() {
        return this.resource;
    }

    @Override
    public void setResource(Object newResource) {
        Object oldResource = this.resource;
        this.resource = newResource;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, oldResource, this.resource));
        }
    }

    @Override
    public ICode getCustomCode(String location) {
        for (ICode code : this.getCustomCode()) {
            if (!code.getLocation().equals(location)) continue;
            return code;
        }
        return null;
    }

    @Override
    public IVariable getVariable(String name) {
        for (IVariable variable : this.getVariables()) {
            if (!variable.getName().equals(name)) continue;
            return variable;
        }
        return null;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 5: {
                return ((InternalEList)this.getVariables()).basicRemove((Object)otherEnd, msgs);
            }
            case 6: {
                return ((InternalEList)this.getCustomCode()).basicRemove((Object)otherEnd, msgs);
            }
            case 7: {
                return ((InternalEList)this.getFlags()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getName();
            }
            case 1: {
                return this.getDescription();
            }
            case 2: {
                return this.getIncludeFilter();
            }
            case 3: {
                return this.getExcludeFilter();
            }
            case 4: {
                return this.getDisabledResources();
            }
            case 5: {
                return this.getVariables();
            }
            case 6: {
                return this.getCustomCode();
            }
            case 7: {
                if (coreType) {
                    return this.getFlags();
                }
                return this.getFlags().map();
            }
            case 8: {
                return this.getVersion();
            }
            case 9: {
                return this.getResource();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setName((String)newValue);
                return;
            }
            case 1: {
                this.setDescription((String)newValue);
                return;
            }
            case 2: {
                this.setIncludeFilter((String)newValue);
                return;
            }
            case 3: {
                this.setExcludeFilter((String)newValue);
                return;
            }
            case 4: {
                this.getDisabledResources().clear();
                this.getDisabledResources().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.getVariables().clear();
                this.getVariables().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.getCustomCode().clear();
                this.getCustomCode().addAll((Collection)newValue);
                return;
            }
            case 7: {
                ((EStructuralFeature.Setting)this.getFlags()).set(newValue);
                return;
            }
            case 8: {
                this.setVersion((String)newValue);
                return;
            }
            case 9: {
                this.setResource(newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 1: {
                this.setDescription(DESCRIPTION_EDEFAULT);
                return;
            }
            case 2: {
                this.setIncludeFilter("");
                return;
            }
            case 3: {
                this.setExcludeFilter("");
                return;
            }
            case 4: {
                this.getDisabledResources().clear();
                return;
            }
            case 5: {
                this.getVariables().clear();
                return;
            }
            case 6: {
                this.getCustomCode().clear();
                return;
            }
            case 7: {
                this.getFlags().clear();
                return;
            }
            case 8: {
                this.setVersion("");
                return;
            }
            case 9: {
                this.setResource(RESOURCE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 1: {
                return DESCRIPTION_EDEFAULT == null ? this.description != null : !DESCRIPTION_EDEFAULT.equals(this.description);
            }
            case 2: {
                return "" == null ? this.includeFilter != null : !"".equals(this.includeFilter);
            }
            case 3: {
                return "" == null ? this.excludeFilter != null : !"".equals(this.excludeFilter);
            }
            case 4: {
                return this.disabledResources != null && !this.disabledResources.isEmpty();
            }
            case 5: {
                return this.variables != null && !this.variables.isEmpty();
            }
            case 6: {
                return this.customCode != null && !this.customCode.isEmpty();
            }
            case 7: {
                return this.flags != null && !this.flags.isEmpty();
            }
            case 8: {
                return "" == null ? this.version != null : !"".equals(this.version);
            }
            case 9: {
                return RESOURCE_EDEFAULT == null ? this.resource != null : !RESOURCE_EDEFAULT.equals(this.resource);
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.getCustomCode((String)arguments.get(0));
            }
            case 1: {
                return this.getVariable((String)arguments.get(0));
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(", description: ");
        result.append(this.description);
        result.append(", includeFilter: ");
        result.append(this.includeFilter);
        result.append(", excludeFilter: ");
        result.append(this.excludeFilter);
        result.append(", disabledResources: ");
        result.append(this.disabledResources);
        result.append(", version: ");
        result.append(this.version);
        result.append(", resource: ");
        result.append(this.resource);
        result.append(')');
        return result.toString();
    }

    @Override
    public <T> T getFlag(Flag identifier, T defaultValue) {
        String value = (String)this.getFlags().get((Object)identifier);
        if (value == null) {
            return defaultValue;
        }
        if (defaultValue instanceof String) {
            return (T)value.toString();
        }
        if (defaultValue instanceof Boolean) {
            return (T)new Boolean(Boolean.parseBoolean(value.toString()));
        }
        if (defaultValue instanceof Integer) {
            try {
                return (T)new Integer(Integer.parseInt(value.toString()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void setVariable(String identifier, String content) {
        this.getOrCreateVariable(identifier).setContent(content);
    }

    private IVariable getOrCreateVariable(String identifier) {
        IVariable variable = this.getVariable(identifier);
        if (variable == null) {
            variable = IDefinitionFactory.eINSTANCE.createVariable();
            variable.setFullName((IPath)new Path(identifier));
            this.getVariables().add((Object)variable);
        }
        return variable;
    }

    @Override
    public void setFlag(String identifier, String value) {
        Flag flag = Flag.getByName(identifier);
        if (flag == null) {
            throw new IllegalArgumentException(String.format("Flag %s is unknown", identifier));
        }
        this.getFlags().put((Object)flag, (Object)value);
    }
}

