/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core.groups;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.core.groups.GroupLaunchConfigurationDelegate;
import org.eclipse.debug.internal.core.groups.GroupLaunchElement;

public class GroupMemberChangeListener
implements ILaunchConfigurationListener {
    private static final String GROUP_TYPE_ID = "org.eclipse.debug.core.groups.GroupLaunchConfigurationType";

    @Override
    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfiguration original = launchManager.getMovedFrom(configuration);
        if (original != null) {
            ILaunchConfigurationType type = launchManager.getLaunchConfigurationType(GROUP_TYPE_ID);
            if (type == null) {
                DebugPlugin.logMessage("cannot find group launch configuration type", null);
                return;
            }
            try {
                ILaunchConfiguration[] iLaunchConfigurationArray = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(type);
                int n = iLaunchConfigurationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ILaunchConfiguration c = iLaunchConfigurationArray[n2];
                    List<GroupLaunchElement> elements = GroupLaunchConfigurationDelegate.createLaunchElements(c);
                    boolean updated = false;
                    for (GroupLaunchElement e : elements) {
                        if (!e.name.equals(original.getName())) continue;
                        updated = true;
                        e.name = configuration.getName();
                    }
                    if (updated) {
                        ILaunchConfigurationWorkingCopy workingCopy = c.getWorkingCopy();
                        GroupLaunchConfigurationDelegate.storeLaunchElements(workingCopy, elements);
                        workingCopy.doSave();
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                DebugPlugin.log(e);
            }
        }
    }

    @Override
    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
    }

    @Override
    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
    }
}

