/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.permadmin;

import java.io.File;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.internal.permadmin.BundlePermissions;
import org.eclipse.osgi.internal.permadmin.PermissionsHash;
import org.osgi.service.permissionadmin.PermissionInfo;

public final class PermissionInfoCollection
extends PermissionCollection {
    private static final long serialVersionUID = 3140511562980923957L;
    private static final Class<?>[] twoStringClassArray = new Class[]{String.class, String.class};
    private static final Class<?>[] oneStringClassArray = new Class[]{String.class};
    private static final Class<?>[] noArgClassArray = new Class[0];
    private static final Class<?>[][] permClassArrayArgs = new Class[][]{noArgClassArray, oneStringClassArray, twoStringClassArray};
    private final Map<Class<? extends Permission>, PermissionCollection> cachedPermissionCollections = new HashMap<Class<? extends Permission>, PermissionCollection>();
    private final boolean hasAllPermission;
    private final PermissionInfo[] permInfos;

    public PermissionInfoCollection(PermissionInfo[] permInfos) {
        this.permInfos = permInfos;
        boolean tempAllPermissions = false;
        int i = 0;
        while (i < permInfos.length && !tempAllPermissions) {
            if (permInfos[i].getType().equals(AllPermission.class.getName())) {
                tempAllPermissions = true;
            }
            ++i;
        }
        this.hasAllPermission = tempAllPermissions;
        this.setReadOnly();
    }

    @Override
    public void add(Permission arg0) {
        throw new SecurityException();
    }

    @Override
    public Enumeration<Permission> elements() {
        return BundlePermissions.EMPTY_ENUMERATION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean implies(Permission perm) {
        PermissionCollection collection;
        if (this.hasAllPermission) {
            return true;
        }
        final Class<?> permClass = perm.getClass();
        Map<Class<? extends Permission>, PermissionCollection> map = this.cachedPermissionCollections;
        synchronized (map) {
            collection = this.cachedPermissionCollections.get(permClass);
        }
        if (collection == null) {
            collection = perm.newPermissionCollection();
            if (collection == null) {
                collection = new PermissionsHash();
            }
            try {
                final PermissionCollection targetCollection = collection;
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        PermissionInfoCollection.this.addPermissions(targetCollection, permClass);
                        return null;
                    }
                });
            }
            catch (Exception e) {
                if (e instanceof PrivilegedActionException) {
                    e = ((PrivilegedActionException)e).getException();
                }
                throw new SecurityException("Exception creating permissions: " + permClass + ": " + e.getMessage(), e);
            }
            map = this.cachedPermissionCollections;
            synchronized (map) {
                PermissionCollection exists = this.cachedPermissionCollections.get(permClass);
                if (exists != null) {
                    collection = exists;
                } else {
                    this.cachedPermissionCollections.put(permClass, collection);
                }
            }
        }
        return collection.implies(perm);
    }

    PermissionInfo[] getPermissionInfos() {
        return this.permInfos;
    }

    void addPermissions(PermissionCollection collection, Class<? extends Permission> permClass) throws Exception {
        String permClassName = permClass.getName();
        Constructor<? extends Permission> constructor = null;
        int numArgs = -1;
        int i = permClassArrayArgs.length - 1;
        while (i >= 0) {
            try {
                constructor = permClass.getConstructor(permClassArrayArgs[i]);
                numArgs = i;
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                --i;
            }
        }
        if (constructor == null) {
            throw new NoSuchMethodException(String.valueOf(permClass.getName()) + ".<init>()");
        }
        i = 0;
        while (i < this.permInfos.length) {
            if (this.permInfos[i].getType().equals(permClassName)) {
                File file;
                Object[] args = new String[numArgs];
                if (numArgs > 0) {
                    args[0] = this.permInfos[i].getName();
                }
                if (numArgs > 1) {
                    args[1] = this.permInfos[i].getActions();
                }
                if (!this.permInfos[i].getType().equals("java.io.FilePermission") || args[0].equals("<<ALL FILES>>") || (file = new File((String)args[0])).isAbsolute()) {
                    collection.add(constructor.newInstance(args));
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearPermissionCache() {
        Map<Class<? extends Permission>, PermissionCollection> map = this.cachedPermissionCollections;
        synchronized (map) {
            this.cachedPermissionCollections.clear();
        }
    }
}

