/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.graphicalcomponents;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.sirius.common.ui.tools.api.util.SWTUtil;
import org.eclipse.sirius.ui.tools.api.views.common.item.ViewpointItem;
import org.eclipse.sirius.ui.tools.internal.viewpoint.ViewpointHelper;
import org.eclipse.sirius.ui.tools.internal.viewpoint.ViewpointsSelectionGraphicalHandler;
import org.eclipse.sirius.ui.tools.internal.views.common.action.DeleteRepresentationAction;
import org.eclipse.sirius.ui.tools.internal.views.common.item.RepresentationDescriptionItemImpl;
import org.eclipse.sirius.ui.tools.internal.views.common.item.RepresentationItemImpl;
import org.eclipse.sirius.ui.tools.internal.views.common.item.ViewpointItemImpl;
import org.eclipse.sirius.ui.tools.internal.views.common.navigator.ManageSessionActionProvider;
import org.eclipse.sirius.ui.tools.internal.views.common.navigator.OpenRepresentationListenerWithViewpointActivation;
import org.eclipse.sirius.ui.tools.internal.views.common.navigator.SiriusCommonContentProvider;
import org.eclipse.sirius.ui.tools.internal.views.common.navigator.sorter.CommonItemSorter;
import org.eclipse.sirius.ui.tools.internal.views.modelexplorer.DeleteActionHandler;
import org.eclipse.sirius.ui.tools.internal.views.modelexplorer.RenameActionHandler;
import org.eclipse.sirius.ui.tools.internal.wizards.CreateRepresentationWizard;
import org.eclipse.sirius.ui.tools.internal.wizards.pages.SiriusRepresentationWithInactiveStatusLabelProvider;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class GraphicalRepresentationHandler
implements SessionManagerListener {
    private Session session;
    private FormToolkit toolkit;
    private SiriusCommonContentProvider siriusCommonContentProvider;
    private Button removeRepresentationInstanceButton;
    private TreeViewer treeViewer;
    private MenuManager menuManager;
    private ManageSessionActionProvider manageSessionActionProvider;
    private FilteredTree representationTree;
    private Action deleteActionHandler;
    private Action renameActionHandler;
    private ViewpointsSelectionGraphicalHandler viewpointsSelectionGraphicalHandler;
    private boolean showButtons;
    private boolean linkNavigatorAndBrowser;
    private boolean addUpdateControls;
    private ILabelProvider labelProvider;
    private ITreeContentProvider contentProvider;
    private boolean filterEmptyViewpoint;
    private Button enableViewpointButton;
    private Button disableViewpointButton;
    private boolean groupByViewpoint;
    private Button groupByViewpointCheckbox;
    private Button showDisabledViewpointCheckboxButton;
    private boolean showGroupinByCheckbox;
    private boolean showDisabledViewpointCheckbox;
    private boolean showDisabledViewpoint;
    private RefreshViewerOnChangeResourceSetListener refreshViewerOnChangeResourceSetListener;

    public GraphicalRepresentationHandler(GraphicalRepresentationHandlerBuilder builder) {
        this.session = builder.session;
        this.toolkit = builder.toolkit;
        this.viewpointsSelectionGraphicalHandler = builder.viewpointsSelectionGraphicalHandler;
        this.showButtons = builder.showButtons;
        this.linkNavigatorAndBrowser = builder.linkNavigatorAndBrowser;
        this.addUpdateControls = builder.addUpdateControls;
        this.filterEmptyViewpoint = builder.filterEmptyViewpoint;
        this.contentProvider = builder.contentProvider;
        this.labelProvider = builder.labelProvider;
        this.showGroupinByCheckbox = builder.showGroupinByCheckbox;
        this.showDisabledViewpointCheckbox = builder.showDisabledViewpointCheckbox;
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    private void handleKeyReleased(KeyEvent event) {
        if (event.stateMask != 0) {
            return;
        }
        int key = event.keyCode;
        if (key == 127) {
            if (this.deleteActionHandler.isEnabled()) {
                this.deleteActionHandler.run();
            }
        } else if (key == 0x100000B && this.renameActionHandler.isEnabled()) {
            this.renameActionHandler.run();
        }
    }

    public void createControl(Composite parentComposite) {
        this.viewpointsSelectionGraphicalHandler = new ViewpointsSelectionGraphicalHandler();
        Composite rootComposite = new Composite(parentComposite, 0);
        rootComposite.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(1).create());
        GridData rootLayoutData = new GridData(4, 4, true, true);
        rootComposite.setLayoutData((Object)rootLayoutData);
        Composite subComposite1 = new Composite(rootComposite, 0);
        GridLayout subComposite1Layout = null;
        subComposite1Layout = this.showButtons ? GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).create() : GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(true).create();
        subComposite1.setLayout((Layout)subComposite1Layout);
        GridData subComposite1LayoutData = new GridData(4, 4, true, true);
        subComposite1.setLayoutData((Object)subComposite1LayoutData);
        this.treeViewer = this.createRepresentationExplorerNavigator(subComposite1);
        GridData layoutData = (GridData)this.treeViewer.getTree().getLayoutData();
        layoutData.heightHint = 50;
        this.viewpointsSelectionGraphicalHandler.createBrowser(subComposite1);
        this.viewpointsSelectionGraphicalHandler.setBrowserMinWidth(200);
        SessionManager.INSTANCE.addSessionsListener((SessionManagerListener)this);
        Composite checkboxComposite = new Composite(rootComposite, 0);
        checkboxComposite.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        if (this.showGroupinByCheckbox) {
            this.createGroupByCheckbox(checkboxComposite);
        } else {
            this.groupByViewpoint = true;
        }
        if (this.showDisabledViewpointCheckbox) {
            this.createShowDisabledViewpointsCheckbox(checkboxComposite);
        } else {
            this.showDisabledViewpoint = true;
        }
        this.refreshViewerOnChangeResourceSetListener = new RefreshViewerOnChangeResourceSetListener();
        this.session.getTransactionalEditingDomain().addResourceSetListener((ResourceSetListener)this.refreshViewerOnChangeResourceSetListener);
    }

    private void createShowDisabledViewpointsCheckbox(Composite rootComposite) {
        this.showDisabledViewpointCheckboxButton = new Button(rootComposite, 32);
        this.showDisabledViewpointCheckboxButton.setText(Messages.GraphicalRepresentationHandler_checkBoxShowDisabledViewpoints_label);
        this.showDisabledViewpointCheckboxButton.setSelection(true);
        this.showDisabledViewpoint = true;
        this.showDisabledViewpointCheckboxButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.widget;
                if (button.getSelection()) {
                    GraphicalRepresentationHandler.this.showDisabledViewpoint = true;
                } else {
                    GraphicalRepresentationHandler.this.showDisabledViewpoint = false;
                }
                GraphicalRepresentationHandler.this.initInput();
            }
        });
    }

    private void createGroupByCheckbox(Composite rootComposite) {
        this.groupByViewpointCheckbox = new Button(rootComposite, 32);
        this.groupByViewpointCheckbox.setText(Messages.GraphicalRepresentationHandler_checkBoxGroupByViewpoint_label);
        this.groupByViewpointCheckbox.setSelection(true);
        this.groupByViewpoint = true;
        this.groupByViewpointCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.widget;
                if (button.getSelection()) {
                    GraphicalRepresentationHandler.this.groupByViewpoint = true;
                } else {
                    GraphicalRepresentationHandler.this.groupByViewpoint = false;
                }
                GraphicalRepresentationHandler.this.initInput();
            }
        });
    }

    private List<ViewpointItemImpl> getViewpointItems() {
        ArrayList<ViewpointItemImpl> viewpointItemList = new ArrayList<ViewpointItemImpl>();
        Collection<Viewpoint> availableViewpoints = ViewpointHelper.getAvailableViewpoints(this.session);
        for (Viewpoint viewpoint : availableViewpoints) {
            viewpointItemList.add(new ViewpointItemImpl(this.session, viewpoint, this));
        }
        return viewpointItemList;
    }

    private List<RepresentationDescriptionItemImpl> getRepresentationDescriptionsItems() {
        ArrayList<RepresentationDescriptionItemImpl> representationItemList = new ArrayList<RepresentationDescriptionItemImpl>();
        Collection<Viewpoint> availableViewpoints = ViewpointHelper.getAvailableViewpoints(this.session);
        for (Viewpoint viewpoint : availableViewpoints) {
            EList ownedRepresentations = viewpoint.getOwnedRepresentations();
            for (RepresentationDescription representationDescription : ownedRepresentations) {
                representationItemList.add(new RepresentationDescriptionItemImpl(this.session, representationDescription, this, viewpoint));
            }
        }
        return representationItemList;
    }

    public void initInput() {
        if (this.groupByViewpoint) {
            List<ViewpointItemImpl> viewpointItems = this.getViewpointItems();
            if (this.showDisabledViewpoint) {
                this.treeViewer.setInput(viewpointItems);
            } else {
                this.treeViewer.setInput(viewpointItems.stream().filter(vpItem -> ViewpointHelper.isViewpointEnabledInSession(this.session, vpItem.getViewpoint())).collect(Collectors.toList()));
            }
        } else {
            List<RepresentationDescriptionItemImpl> representationDescriptionItems = this.getRepresentationDescriptionsItems();
            if (this.showDisabledViewpoint) {
                this.treeViewer.setInput(representationDescriptionItems);
            } else {
                this.treeViewer.setInput(representationDescriptionItems.stream().filter(descItem -> ViewpointHelper.isViewpointEnabledInSession(this.session, descItem.getViewpoint())).collect(Collectors.toList()));
            }
        }
        this.treeViewer.expandToLevel(2);
        if (this.treeViewer.getTree().getItemCount() > 0) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection(this.treeViewer.getTree().getItem(0).getData()));
        }
        this.treeViewer.refresh(true);
    }

    private TreeViewer createRepresentationExplorerNavigator(Composite parent) {
        Object contentProviderToUse;
        Composite subComposite = null;
        subComposite = this.toolkit != null ? this.toolkit.createComposite(parent, 0) : new Composite(parent, 0);
        subComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.widthHint = 350;
        subComposite.setLayoutData((Object)layoutData);
        PatternFilter filter = new PatternFilter();
        filter.setIncludeLeadingWildcard(true);
        this.representationTree = SWTUtil.createFilteredTree((Composite)subComposite, (int)2050, (PatternFilter)filter);
        this.treeViewer = this.representationTree.getViewer();
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumHeight = 200;
        this.treeViewer.getControl().setLayoutData((Object)gridData);
        this.treeViewer.getTree().setHeaderVisible(false);
        this.treeViewer.getTree().setLinesVisible(false);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer);
        if (this.contentProvider != null) {
            contentProviderToUse = this.contentProvider;
        } else {
            this.siriusCommonContentProvider = new SiriusCommonContentProvider(new OpenRepresentationListenerWithViewpointActivation(this.session));
            contentProviderToUse = this.siriusCommonContentProvider;
        }
        this.treeViewer.setContentProvider((IContentProvider)contentProviderToUse);
        if (this.labelProvider != null) {
            this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        } else {
            this.treeViewer.setLabelProvider((IBaseLabelProvider)new SiriusRepresentationWithInactiveStatusLabelProvider());
        }
        this.treeViewer.setSorter((ViewerSorter)new CommonItemSorter());
        if (this.addUpdateControls) {
            this.bindKeyToActions();
            this.initializeMenusAndActions();
            this.treeViewer.addDoubleClickListener((IDoubleClickListener)new ViewpointActivationAndRepresentationCreationDoubleClickListener());
        }
        if (this.showButtons) {
            this.createRepresentationExplorerButton(subComposite, this.treeViewer);
            this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)new UpdateRepresentationButtonsAtSelectionChangeListener());
        }
        if (this.linkNavigatorAndBrowser) {
            this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)new UpdateBrowserAtSelectionChangeListener());
        }
        if (this.filterEmptyViewpoint) {
            this.treeViewer.addFilter(new ViewerFilter((ITreeContentProvider)contentProviderToUse){
                private final /* synthetic */ ITreeContentProvider val$contentProviderToUse;
                {
                    this.val$contentProviderToUse = iTreeContentProvider;
                }

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return !(element instanceof ViewpointItem) || this.val$contentProviderToUse.getChildren(element).length != 0;
                }
            });
        }
        return this.treeViewer;
    }

    private void bindKeyToActions() {
        this.deleteActionHandler = new DeleteActionHandler((ISelectionProvider)this.treeViewer);
        this.renameActionHandler = new RenameActionHandler((ISelectionProvider)this.treeViewer);
        this.treeViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                GraphicalRepresentationHandler.this.handleKeyReleased(event);
            }
        });
    }

    private void initializeMenusAndActions() {
        this.menuManager = new MenuManager();
        this.menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                GraphicalRepresentationHandler.this.manageSessionActionProvider.setContext(new ActionContext(GraphicalRepresentationHandler.this.treeViewer.getSelection()));
                GraphicalRepresentationHandler.this.manageSessionActionProvider.fillContextMenu((IMenuManager)GraphicalRepresentationHandler.this.menuManager);
            }
        });
        Menu menu = this.menuManager.createContextMenu(this.treeViewer.getControl());
        this.menuManager.setRemoveAllWhenShown(true);
        this.manageSessionActionProvider = new ManageSessionActionProvider();
        this.manageSessionActionProvider.initFromViewer((StructuredViewer)this.treeViewer);
        this.treeViewer.getControl().setMenu(menu);
    }

    private void createRepresentationExplorerButton(Composite parent, TreeViewer theTreeViewer) {
        Composite buttonsComposite = this.createButtonsComposite(parent);
        Button newRepButton = this.addButton(buttonsComposite, Messages.GraphicalRepresentationHandler_button_newRepresentation, () -> {
            CreateRepresentationWizard wizard = new CreateRepresentationWizard(this.session);
            wizard.init();
            WizardDialog dialog = new WizardDialog(parent.getShell(), (IWizard)wizard);
            dialog.setMinimumPageSize(1000, 600);
            dialog.create();
            dialog.getShell().setText(Messages.GraphicalRepresentationHandler_CreateRepresentationWizard_title);
            dialog.open();
        });
        newRepButton.setToolTipText(Messages.GraphicalRepresentationHandler_newRepresentationButton_tooltip);
        this.removeRepresentationInstanceButton = this.addButton(buttonsComposite, Messages.GraphicalRepresentationHandler_button_removeRepresentation, () -> {
            if (theTreeViewer != null) {
                IStructuredSelection selection = (IStructuredSelection)theTreeViewer.getSelection();
                List selectedObjects = selection.toList();
                if (!selectedObjects.isEmpty()) {
                    Set<DRepresentationDescriptor> representationDescriptors = selectedObjects.stream().filter(object -> object instanceof RepresentationItemImpl).map(object -> ((RepresentationItemImpl)object).getDRepresentationDescriptor()).collect(Collectors.toSet());
                    DeleteRepresentationAction deleteRepresentationAction = new DeleteRepresentationAction(representationDescriptors);
                    deleteRepresentationAction.run();
                }
                theTreeViewer.refresh();
            }
        });
        this.removeRepresentationInstanceButton.setToolTipText(Messages.GraphicalRepresentationHandler_removeRepresentationButton_tooltip);
        this.enableViewpointButton = this.addButton(buttonsComposite, Messages.GraphicalRepresentationHandler_button_activateViewpoint, () -> {
            if (theTreeViewer != null) {
                this.toggleViewpointState((IStructuredSelection)theTreeViewer.getSelection(), true);
            }
        });
        this.enableViewpointButton.setToolTipText(Messages.GraphicalRepresentationHandler_enableViewpointButton_tooltip);
        this.disableViewpointButton = this.addButton(buttonsComposite, Messages.GraphicalRepresentationHandler_button_deactivateViewpoint, () -> {
            if (theTreeViewer != null) {
                this.toggleViewpointState((IStructuredSelection)theTreeViewer.getSelection(), false);
            }
        });
        this.disableViewpointButton.setToolTipText(Messages.GraphicalRepresentationHandler_disableViewpointButton_tooltip);
        this.enableViewpointButton.setEnabled(false);
        this.disableViewpointButton.setEnabled(false);
        this.removeRepresentationInstanceButton.setEnabled(false);
        this.deleteActionHandler.setEnabled(false);
        this.renameActionHandler.setEnabled(false);
    }

    private void toggleViewpointState(IStructuredSelection selection, boolean enable) {
        List selectedObjects = selection.toList();
        if (!selectedObjects.isEmpty()) {
            boolean canEnableOrDisableViewpoints = selectedObjects.stream().allMatch(object -> object instanceof ViewpointItemImpl);
            if (canEnableOrDisableViewpoints) {
                HashSet<ViewpointItemImpl> viewpointsToActivate = new HashSet<ViewpointItemImpl>();
                for (Object obj : selectedObjects) {
                    if (!(obj instanceof ViewpointItemImpl)) continue;
                    viewpointsToActivate.add((ViewpointItemImpl)obj);
                }
                this.handleViewpointActivationFomViewer(viewpointsToActivate, enable);
            } else {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)MessageFormat.format(Messages.GraphicalRepresentationHandler_button_activateDeactivateViewpoint_incorrectSelection_title, enable ? Messages.GraphicalRepresentationHandler_button_activateDeactivateViewpoint_incorrectSelection_activationLabel : Messages.GraphicalRepresentationHandler_button_activateDeactivateViewpoint_incorrectSelection_deactivationLabel), (String)Messages.GraphicalRepresentationHandler_button_activateDeactivateViewpoint_incorrectSelection_message);
            }
        }
    }

    private void handleViewpointActivationFomViewer(Set<ViewpointItemImpl> viewpointsToActivate, boolean enable) {
        this.treeViewer.getTree().setRedraw(false);
        Stream<Viewpoint> viewpoints = viewpointsToActivate.stream().map(viewpointItemImpl -> viewpointItemImpl.getViewpoint());
        ViewpointHelper.handleViewpointActivation(this.session, viewpoints.collect(Collectors.toSet()), enable, true);
        this.treeViewer.getTree().setRedraw(true);
        this.treeViewer.refresh();
        this.treeViewer.setSelection((ISelection)new StructuredSelection(viewpointsToActivate.stream().collect(Collectors.toList())));
    }

    private Composite createButtonsComposite(Composite parent) {
        Composite subComposite = null;
        subComposite = this.toolkit != null ? this.toolkit.createComposite(parent, 0) : new Composite(parent, 0);
        subComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(0, 0).create());
        GridData layoutData = new GridData(16384, 128, false, false);
        layoutData.widthHint = 70;
        subComposite.setLayoutData((Object)layoutData);
        Composite buttonsComposite = null;
        buttonsComposite = this.toolkit != null ? this.toolkit.createComposite(subComposite, 0) : new Composite(subComposite, 0);
        FillLayout buttonsLayout = new FillLayout(1);
        buttonsLayout.spacing = 5;
        buttonsComposite.setLayout((Layout)buttonsLayout);
        return buttonsComposite;
    }

    protected Button addButton(Composite parent, String name, final Runnable body) {
        Button button = null;
        if (this.toolkit != null) {
            button = this.toolkit.createButton(parent, name, 8);
        } else {
            button = new Button(parent, 8);
            button.setText(name);
        }
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (body != null) {
                    body.run();
                }
            }
        });
        return button;
    }

    public void dispose() {
        this.siriusCommonContentProvider.dispose();
        SessionManager.INSTANCE.removeSessionsListener((SessionManagerListener)this);
        if (this.session != null && this.session.getTransactionalEditingDomain() != null) {
            this.session.getTransactionalEditingDomain().removeResourceSetListener((ResourceSetListener)this.refreshViewerOnChangeResourceSetListener);
        }
        this.session = null;
        this.treeViewer = null;
        this.manageSessionActionProvider = null;
        this.siriusCommonContentProvider = null;
        this.menuManager = null;
        this.toolkit = null;
    }

    public void notifyAddSession(Session newSession) {
    }

    public void notifyRemoveSession(Session removedSession) {
        if (this.siriusCommonContentProvider != null) {
            this.siriusCommonContentProvider.removeRefreshViewerTriggers(removedSession);
        }
    }

    public void viewpointSelected(Viewpoint selectedSirius) {
    }

    public void viewpointDeselected(Viewpoint deselectedSirius) {
    }

    public void notify(Session updated, int notification) {
        if (this.session.equals(updated)) {
            switch (notification) {
                case 2: {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                        if (!this.representationTree.isDisposed()) {
                            this.treeViewer.refresh();
                        }
                    });
                    break;
                }
                case 7: {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                        if (!this.representationTree.isDisposed()) {
                            this.treeViewer.refresh();
                            if (this.siriusCommonContentProvider != null) {
                                this.siriusCommonContentProvider.addRefreshViewerTrigger(updated);
                            }
                        }
                    });
                    break;
                }
                case 5: 
                case 10: 
                case 16: {
                    PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
                        if (this.session != null && !this.treeViewer.getControl().isDisposed()) {
                            this.initInput();
                        }
                    });
                    break;
                }
            }
        }
    }

    public static class GraphicalRepresentationHandlerBuilder {
        private ViewpointsSelectionGraphicalHandler viewpointsSelectionGraphicalHandler;
        private Session session;
        private FormToolkit toolkit;
        private boolean showButtons;
        private boolean linkNavigatorAndBrowser;
        private boolean addUpdateControls;
        private ILabelProvider labelProvider;
        private ITreeContentProvider contentProvider;
        private boolean showDisabledViewpointCheckbox;
        private boolean filterEmptyViewpoint;
        private boolean showGroupinByCheckbox;

        public GraphicalRepresentationHandlerBuilder(Session theSession) {
            this.session = theSession;
            this.viewpointsSelectionGraphicalHandler = null;
            this.showButtons = false;
            this.linkNavigatorAndBrowser = false;
            this.addUpdateControls = false;
            this.filterEmptyViewpoint = false;
            this.showGroupinByCheckbox = false;
            this.labelProvider = null;
            this.contentProvider = null;
        }

        public GraphicalRepresentationHandlerBuilder useToolkitToCreateGraphicComponents(FormToolkit theToolkit) {
            this.toolkit = theToolkit;
            return this;
        }

        public GraphicalRepresentationHandlerBuilder activateRepresentationAndViewpointControls() {
            this.addUpdateControls = true;
            this.showButtons = true;
            return this;
        }

        public GraphicalRepresentationHandlerBuilder activateGroupingByCheckbox() {
            this.showGroupinByCheckbox = true;
            return this;
        }

        public GraphicalRepresentationHandlerBuilder activateShowDisabledViewpointsCheckbox() {
            this.showDisabledViewpointCheckbox = true;
            return this;
        }

        public GraphicalRepresentationHandlerBuilder activateBrowserWithViewpointAndRepresentationDescriptionInformation() {
            this.linkNavigatorAndBrowser = true;
            this.viewpointsSelectionGraphicalHandler = new ViewpointsSelectionGraphicalHandler();
            return this;
        }

        public GraphicalRepresentationHandlerBuilder customizeContentAndLabel(ITreeContentProvider theContentProvider, ILabelProvider theLabelProvider) {
            this.labelProvider = theLabelProvider;
            this.contentProvider = theContentProvider;
            return this;
        }

        public GraphicalRepresentationHandlerBuilder filterEmptyViewpoints() {
            this.filterEmptyViewpoint = true;
            return this;
        }

        public GraphicalRepresentationHandler build() {
            return new GraphicalRepresentationHandler(this);
        }
    }

    public class RefreshViewerOnChangeResourceSetListener
    implements ResourceSetListener {
        public NotificationFilter getFilter() {
            return null;
        }

        public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
            return null;
        }

        public void resourceSetChanged(ResourceSetChangeEvent event) {
            List notifications = event.getNotifications();
            for (Notification notification : notifications) {
                switch (notification.getEventType()) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        if (notification.getNewValue() instanceof DRepresentation || notification.getOldValue() instanceof DRepresentation) {
                            PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                                if (!GraphicalRepresentationHandler.this.treeViewer.getTree().isDisposed()) {
                                    GraphicalRepresentationHandler.this.treeViewer.refresh();
                                }
                            });
                            break;
                        }
                        if (!(notification.getNotifier() instanceof DAnalysis)) break;
                        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                            if (!GraphicalRepresentationHandler.this.treeViewer.getTree().isDisposed()) {
                                GraphicalRepresentationHandler.this.initInput();
                            }
                        });
                        break;
                    }
                }
            }
        }

        public boolean isAggregatePrecommitListener() {
            return false;
        }

        public boolean isPrecommitOnly() {
            return false;
        }

        public boolean isPostcommitOnly() {
            return true;
        }
    }

    private final class UpdateBrowserAtSelectionChangeListener
    implements ISelectionChangedListener {
        private UpdateBrowserAtSelectionChangeListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (event.getSelection() instanceof TreeSelection) {
                TreeSelection selection = (TreeSelection)event.getSelection();
                Object firstElement = selection.getFirstElement();
                if (firstElement instanceof ViewpointItemImpl) {
                    GraphicalRepresentationHandler.this.viewpointsSelectionGraphicalHandler.setBrowserInput(((ViewpointItemImpl)firstElement).getViewpoint());
                } else if (firstElement instanceof RepresentationDescriptionItemImpl) {
                    RepresentationDescriptionItemImpl representationDescriptionItemImpl = (RepresentationDescriptionItemImpl)firstElement;
                    GraphicalRepresentationHandler.this.viewpointsSelectionGraphicalHandler.setBrowserInput(representationDescriptionItemImpl.getViewpoint(), (RepresentationDescription)representationDescriptionItemImpl.getWrappedObject());
                } else if (firstElement instanceof RepresentationItemImpl) {
                    RepresentationItemImpl representationItem = (RepresentationItemImpl)firstElement;
                    RepresentationDescriptionItemImpl representationDescriptionItemImpl = (RepresentationDescriptionItemImpl)representationItem.getParent();
                    GraphicalRepresentationHandler.this.viewpointsSelectionGraphicalHandler.setBrowserInput(representationDescriptionItemImpl.getViewpoint(), (RepresentationDescription)representationDescriptionItemImpl.getWrappedObject());
                }
            }
        }
    }

    private final class UpdateRepresentationButtonsAtSelectionChangeListener
    implements ISelectionChangedListener {
        private UpdateRepresentationButtonsAtSelectionChangeListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (event.getSelection().isEmpty()) {
                GraphicalRepresentationHandler.this.removeRepresentationInstanceButton.setEnabled(false);
                GraphicalRepresentationHandler.this.deleteActionHandler.setEnabled(false);
                GraphicalRepresentationHandler.this.renameActionHandler.setEnabled(false);
                GraphicalRepresentationHandler.this.enableViewpointButton.setEnabled(false);
                GraphicalRepresentationHandler.this.disableViewpointButton.setEnabled(false);
            } else if (event.getSelection() instanceof TreeSelection) {
                TreeSelection selection = (TreeSelection)event.getSelection();
                Iterator selectionIte = selection.iterator();
                boolean allRepresentationItem = true;
                while (selectionIte.hasNext() && allRepresentationItem) {
                    Object object = selectionIte.next();
                    if (object instanceof RepresentationItemImpl) continue;
                    allRepresentationItem = false;
                }
                if (allRepresentationItem) {
                    GraphicalRepresentationHandler.this.removeRepresentationInstanceButton.setEnabled(true);
                    GraphicalRepresentationHandler.this.deleteActionHandler.setEnabled(true);
                    GraphicalRepresentationHandler.this.renameActionHandler.setEnabled(true);
                } else {
                    GraphicalRepresentationHandler.this.removeRepresentationInstanceButton.setEnabled(false);
                    GraphicalRepresentationHandler.this.deleteActionHandler.setEnabled(false);
                    GraphicalRepresentationHandler.this.renameActionHandler.setEnabled(false);
                }
                GraphicalRepresentationHandler.this.enableViewpointButton.setEnabled(true);
                GraphicalRepresentationHandler.this.disableViewpointButton.setEnabled(true);
            }
        }
    }

    private final class ViewpointActivationAndRepresentationCreationDoubleClickListener
    implements IDoubleClickListener {
        private ViewpointActivationAndRepresentationCreationDoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            if (event.getSelection() instanceof StructuredSelection) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                if (selection.getFirstElement() instanceof ViewpointItemImpl) {
                    boolean activateViewpoint;
                    ViewpointItemImpl viewpointItem = (ViewpointItemImpl)selection.getFirstElement();
                    boolean bl = activateViewpoint = !ViewpointHelper.isViewpointEnabledInSession(GraphicalRepresentationHandler.this.session, viewpointItem.getViewpoint());
                    if (activateViewpoint) {
                        HashSet<ViewpointItemImpl> viewpointsToActivate = new HashSet<ViewpointItemImpl>();
                        viewpointsToActivate.add(viewpointItem);
                        GraphicalRepresentationHandler.this.handleViewpointActivationFomViewer(viewpointsToActivate, activateViewpoint);
                    } else {
                        HashSet<ViewpointItemImpl> viewpointsToActivate = new HashSet<ViewpointItemImpl>();
                        viewpointsToActivate.add(viewpointItem);
                        GraphicalRepresentationHandler.this.handleViewpointActivationFomViewer(viewpointsToActivate, activateViewpoint);
                    }
                } else if (selection.getFirstElement() instanceof RepresentationDescriptionItemImpl) {
                    RepresentationDescriptionItemImpl representationDescriptionItem = (RepresentationDescriptionItemImpl)selection.getFirstElement();
                    GraphicalRepresentationHandler.this.treeViewer.getTree().setRedraw(false);
                    CreateRepresentationWizard wizard = new CreateRepresentationWizard(GraphicalRepresentationHandler.this.session, representationDescriptionItem);
                    wizard.init();
                    WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
                    dialog.setMinimumPageSize(1000, 600);
                    dialog.create();
                    dialog.getShell().setText(Messages.GraphicalRepresentationHandler_CreateRepresentationWizard_title);
                    dialog.open();
                    GraphicalRepresentationHandler.this.treeViewer.getTree().setRedraw(true);
                    GraphicalRepresentationHandler.this.treeViewer.refresh();
                    GraphicalRepresentationHandler.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)representationDescriptionItem));
                }
            }
        }
    }
}

