/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.paperclips;

import org.eclipse.sirius.table.ui.tools.internal.paperclips.BigPiece;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.PaperClips;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.Print;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.PrintIterator;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.PrintPiece;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.internal.util.Util;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

class BigIterator
implements PrintIterator {
    private final PrintIterator target;
    private final Device device;
    private PrintPiece currentPiece;
    private int xOffset;
    private int yOffset;

    BigIterator(Print target, Device device, GC gc) {
        Util.notNull(device, gc, target);
        this.target = target.iterator(device, gc);
        this.device = device;
        this.currentPiece = null;
        this.xOffset = 0;
        this.yOffset = 0;
    }

    BigIterator(BigIterator that) {
        this.target = that.target.copy();
        this.device = that.device;
        this.currentPiece = that.currentPiece;
        this.xOffset = that.xOffset;
        this.yOffset = that.yOffset;
    }

    @Override
    public Point minimumSize() {
        return this.target.minimumSize();
    }

    @Override
    public Point preferredSize() {
        return this.target.preferredSize();
    }

    @Override
    public boolean hasNext() {
        return this.currentPiece != null || this.target.hasNext();
    }

    private Point estimatePagesRequired(int width, int height) {
        if (width <= 0 || height <= 0) {
            return new Point(0, 0);
        }
        Point pref = this.target.preferredSize();
        Point prefPages = new Point(pref.x / width, pref.y / height);
        Point min = this.target.minimumSize();
        Point minPages = new Point(Math.max((min.x + width - 1) / width, 1), Math.max((min.y + height - 1) / height, 1));
        return new Point(Math.max(prefPages.x, minPages.x), Math.max(prefPages.y, minPages.y));
    }

    @Override
    public PrintPiece next(int width, int height) {
        if (!this.hasNext()) {
            PaperClips.error("No more content");
        }
        if (this.currentPiece == null) {
            Point pages = this.estimatePagesRequired(width, height);
            this.currentPiece = PaperClips.next(this.target, width * pages.x, height * pages.y);
            if (this.currentPiece == null) {
                return null;
            }
            this.xOffset = 0;
            this.yOffset = 0;
        }
        BigPiece result = new BigPiece(this.currentPiece, new Point(width, height), this.xOffset, this.yOffset);
        this.xOffset += width;
        if (this.xOffset >= this.currentPiece.getSize().x) {
            this.xOffset = 0;
            this.yOffset += height;
        }
        if (this.yOffset >= this.currentPiece.getSize().y) {
            this.currentPiece = null;
        }
        return result;
    }

    @Override
    public PrintIterator copy() {
        return new BigIterator(this);
    }
}

