/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.migration;

import java.text.MessageFormat;
import java.util.UUID;
import org.eclipse.emf.common.util.EList;
import org.eclipse.sirius.business.api.migration.AbstractRepresentationsFileMigrationParticipant;
import org.eclipse.sirius.diagram.tools.api.DiagramPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DView;
import org.osgi.framework.Version;

public class SetChangeIdMigrationParticipant
extends AbstractRepresentationsFileMigrationParticipant {
    public static final Version MIGRATION_VERSION = new Version("14.6.0.202110251100");

    public Version getMigrationVersion() {
        return MIGRATION_VERSION;
    }

    protected void postLoad(DAnalysis dAnalysis, Version loadedVersion) {
        if (loadedVersion.compareTo(MIGRATION_VERSION) < 0) {
            StringBuilder sb = new StringBuilder(Messages.SetChangeIdMigrationParticipant_title);
            EList ownedViews = dAnalysis.getOwnedViews();
            boolean migrationOccured = false;
            for (DView view : ownedViews) {
                EList ownedRepresentationsDescriptors = view.getOwnedRepresentationDescriptors();
                for (DRepresentationDescriptor descriptor : ownedRepresentationsDescriptors) {
                    if (descriptor.getChangeId() != null) continue;
                    migrationOccured = true;
                    sb.append(MessageFormat.format(Messages.SetChangeIdMigrationParticipant_changeIDModified, descriptor.getName()));
                    descriptor.setChangeId(UUID.randomUUID().toString());
                }
            }
            if (migrationOccured) {
                DiagramPlugin.getDefault().logInfo(sb.toString());
                migrationOccured = false;
            }
        }
    }
}

