/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.graphical.edit.policies;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.util.ObjectAdapter;
import org.eclipse.gmf.runtime.diagram.ui.commands.ArrangeCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.DeferredLayoutCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ContainerEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.requests.ArrangeRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramElementContainerEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.commands.CenterEdgeLayoutCommand;
import org.eclipse.sirius.diagram.ui.internal.edit.commands.DistributeCommand;
import org.eclipse.sirius.diagram.ui.internal.layout.GenericLayoutProvider;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.LayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.api.requests.DistributeRequest;
import org.eclipse.sirius.diagram.ui.tools.internal.commands.SnapCommand;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.provider.LayoutService;

public class SiriusContainerEditPolicy
extends ContainerEditPolicy {
    private final Predicate<Object> isRegionEditPart = new Predicate<Object>(){

        public boolean apply(Object input) {
            return input instanceof AbstractDiagramElementContainerEditPart && ((AbstractDiagramElementContainerEditPart)input).isRegion();
        }
    };

    public Command getCommand(Request request) {
        if ("distribute".equals(request.getType())) {
            return this.getDistributeCommand((DistributeRequest)request);
        }
        return super.getCommand(request);
    }

    protected Command getArrangeCommand(ArrangeRequest request) {
        EditPart host;
        if (("arrangeSelectionAction".equals(request.getType()) || "toolbarArrangeSelectionAction".equals(request.getType())) && Iterables.any((Iterable)request.getPartsToArrange(), this.isRegionEditPart)) {
            return UnexecutableCommand.INSTANCE;
        }
        Command commandToReturn = this.doDuplicatedGetArrangeCommand(request);
        if (commandToReturn != null && (host = this.getHost()) instanceof GraphicalEditPart) {
            CenterEdgeLayoutCommand centerEdgeLayoutCommand = new CenterEdgeLayoutCommand((GraphicalEditPart)host);
            commandToReturn = commandToReturn.chain((Command)new ICommandProxy((ICommand)centerEdgeLayoutCommand));
        }
        return commandToReturn;
    }

    private Command doDuplicatedGetArrangeCommand(ArrangeRequest request) {
        Command snapCmd;
        IPreferenceStore preferenceStore;
        if ("arrange_deferred".equals(request.getType())) {
            String layoutType = request.getLayoutType();
            TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
            return new ICommandProxy((ICommand)new DeferredLayoutCommand(editingDomain, request.getViewAdaptersToArrange(), (IGraphicalEditPart)this.getHost(), layoutType));
        }
        String layoutDesc = request.getLayoutType() != null ? request.getLayoutType() : "DEFAULT";
        boolean offsetFromBoundingBox = false;
        List editparts = new ArrayList();
        if ("arrangeAllAction".equals(request.getType()) || "toolbarArrangeAllAction".equals(request.getType())) {
            editparts = ((IGraphicalEditPart)this.getHost()).getChildren();
            request.setPartsToArrange(editparts);
        }
        if ("arrangeSelectionAction".equals(request.getType()) || "toolbarArrangeSelectionAction".equals(request.getType())) {
            editparts = request.getPartsToArrange();
            offsetFromBoundingBox = true;
        }
        if ("arrange_radial".equals(request.getType())) {
            editparts = request.getPartsToArrange();
            offsetFromBoundingBox = true;
            layoutDesc = "RADIAL";
        }
        if (editparts.isEmpty()) {
            return null;
        }
        ArrayList<String> hints = new ArrayList<String>(2);
        hints.add(layoutDesc);
        hints.add((String)this.getHost());
        ObjectAdapter layoutHint = new ObjectAdapter(hints);
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        CompositeTransactionalCommand ctc = new CompositeTransactionalCommand(editingDomain, "");
        ctc.setLabel(Messages.SiriusContainerEditPolicy_arrangeCommandLabel);
        ctc.add((IUndoableOperation)new ArrangeCommand(editingDomain, "", null, editparts, (IAdaptable)layoutHint, offsetFromBoundingBox));
        IGraphicalEditPart firstEditPart = (IGraphicalEditPart)editparts.get(0);
        if (firstEditPart.getViewer() instanceof DiagramGraphicalViewer && (preferenceStore = ((DiagramGraphicalViewer)firstEditPart.getViewer()).getWorkspaceViewerPreferenceStore()) != null && preferenceStore.getBoolean("rulergrid.snaptogrid") && (snapCmd = this.getSnapCommand((Request)request)) != null) {
            ctc.add((IUndoableOperation)new CommandProxy(this.getSnapCommand((Request)request)));
        }
        return new ICommandProxy((ICommand)ctc);
    }

    private Command getSnapCommand(Request request) {
        List editparts = null;
        if (request instanceof GroupRequest) {
            editparts = ((GroupRequest)request).getEditParts();
        } else if (request instanceof ArrangeRequest) {
            editparts = ((ArrangeRequest)request).getPartsToArrange();
        }
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (editparts != null && this.shouldLaunchSnapTo(editparts)) {
            return new ICommandProxy((ICommand)new SnapCommand(editingDomain, editparts));
        }
        return null;
    }

    private boolean shouldLaunchSnapTo(List<? extends IGraphicalEditPart> editparts) {
        LayoutProvider layoutProvider;
        Optional optionalFirstEditPart = editparts.stream().findFirst();
        if (optionalFirstEditPart.isPresent() && (layoutProvider = LayoutService.getProvider((IGraphicalEditPart)optionalFirstEditPart.get())) instanceof GenericLayoutProvider) {
            return ((GenericLayoutProvider)layoutProvider).shouldLaunchSnapTo((IGraphicalEditPart)optionalFirstEditPart.get());
        }
        return true;
    }

    protected Command getDistributeCommand(DistributeRequest request) {
        List editparts = request.getEditParts();
        if (!editparts.isEmpty() && this.getHost() instanceof IGraphicalEditPart) {
            return new ICommandProxy((ICommand)new DistributeCommand(((IGraphicalEditPart)this.getHost()).getEditingDomain(), editparts, request.getDistributeType()));
        }
        return null;
    }
}

