/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar;

import org.eclipse.swt.events.ArmEvent;
import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class MenuContributionItemArmListener
implements ArmListener {
    private Control control;
    private Shell currentTooltip;

    public MenuContributionItemArmListener(Control control) {
        this.control = control;
    }

    public void widgetArmed(ArmEvent e) {
        Object data;
        Widget widget = e.widget;
        if (widget instanceof MenuItem && (data = ((MenuItem)widget).getData("Tooltip")) instanceof String) {
            this.createTooltip((String)data);
        }
    }

    private void createTooltip(String tooltipText) {
        if (this.currentTooltip != null && !this.currentTooltip.isDisposed()) {
            this.currentTooltip.dispose();
        }
        final Shell tip = new Shell(this.control.getShell(), 16388);
        tip.setLayout((Layout)new FillLayout());
        Label label = new Label((Composite)tip, 0);
        Display display = PlatformUI.getWorkbench().getDisplay();
        label.setForeground(display.getSystemColor(28));
        label.setBackground(display.getSystemColor(29));
        label.setText(tooltipText);
        Point size = tip.computeSize(-1, -1);
        Point pt = PlatformUI.getWorkbench().getDisplay().getCursorLocation();
        int offset = 15;
        tip.setBounds(pt.x + offset, pt.y - offset, size.x, size.y);
        tip.setVisible(true);
        this.control.getDisplay().timerExec(3000, new Runnable(){

            @Override
            public void run() {
                tip.dispose();
            }
        });
        this.currentTooltip = tip;
    }
}

