/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.metamodel.helper;

import java.util.Collection;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DiagramFactory;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.HideFilter;
import org.eclipse.sirius.diagram.HideLabelFilter;
import org.eclipse.sirius.diagram.business.api.helper.graphicalfilters.HideFilterHelper;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;

public final class HideFilterHelperImpl
implements HideFilterHelper {
    private HideFilterHelperImpl() {
    }

    public static HideFilterHelperImpl init() {
        return new HideFilterHelperImpl();
    }

    @Override
    public void hide(DDiagramElement element) {
        if (new DDiagramElementQuery(element).isHidden()) {
            return;
        }
        HideFilter filter = DiagramFactory.eINSTANCE.createHideFilter();
        element.getGraphicalFilters().add((Object)filter);
    }

    @Override
    public void reveal(DDiagramElement element) {
        if (!this.isDirectlyHidden(element)) {
            return;
        }
        Object hidefilter = EcoreUtil.getObjectByType((Collection)element.getGraphicalFilters(), (EClassifier)DiagramPackage.eINSTANCE.getHideFilter());
        if (hidefilter instanceof HideFilter) {
            element.getGraphicalFilters().remove(hidefilter);
        }
    }

    private boolean isDirectlyHidden(DDiagramElement element) {
        DDiagramElementQuery query = new DDiagramElementQuery(element);
        return element != null && query.isHidden();
    }

    @Override
    public void hideLabel(DDiagramElement element) {
        if (new DDiagramElementQuery(element).isLabelHidden()) {
            return;
        }
        HideLabelFilter filter = DiagramFactory.eINSTANCE.createHideLabelFilter();
        element.getGraphicalFilters().add((Object)filter);
    }

    @Override
    public void revealLabel(DDiagramElement element) {
        if (!new DDiagramElementQuery(element).isLabelHidden()) {
            return;
        }
        Object filter = EcoreUtil.getObjectByType((Collection)element.getGraphicalFilters(), (EClassifier)DiagramPackage.eINSTANCE.getHideLabelFilter());
        if (filter instanceof HideLabelFilter) {
            element.getGraphicalFilters().remove(filter);
        }
    }
}

