/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.tools.internal.editor.provider;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sirius.business.api.dialect.DRepresentationNotificationFilter;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.tree.DTree;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.DTreeItemContainer;
import org.eclipse.sirius.tree.TreeItemStyle;
import org.eclipse.sirius.tree.TreePackage;
import org.eclipse.sirius.tree.ui.tools.internal.editor.DTreeViewer;
import org.eclipse.sirius.tree.ui.tools.internal.editor.provider.TreeUIUpdaterRunnable;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.style.StylePackage;

public class TreeUIUpdater
extends ResourceSetListenerImpl {
    private DTreeViewer dTreeViewer;
    private Set<DTreeItem> toExpands;
    private Set<DTreeItem> toCollapses;
    private Set<Object> toRefreshInViewer;
    private Set<Object> toUpdateInViewer;

    public TreeUIUpdater(DTreeViewer dTreeViewer, DRepresentation dRepresentation) {
        super((NotificationFilter)new DRepresentationNotificationFilter(dRepresentation));
        this.dTreeViewer = dTreeViewer;
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)dRepresentation);
        if (domain != null) {
            domain.addResourceSetListener((ResourceSetListener)this);
        }
    }

    public boolean isPostcommitOnly() {
        return true;
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        this.toRefreshInViewer = new LinkedHashSet<Object>();
        this.toUpdateInViewer = new LinkedHashSet<Object>();
        this.toCollapses = new LinkedHashSet<DTreeItem>();
        this.toExpands = new LinkedHashSet<DTreeItem>();
        this.analyseNotifications(event.getNotifications());
        this.updateDTreeViewer();
    }

    private void analyseNotifications(List<Notification> notifications) {
        for (Notification notification : notifications) {
            this.analyseNotification(notification);
        }
    }

    private void analyseNotification(Notification notification) {
        Object notifier = notification.getNotifier();
        if (this.isDTreeItemContainerOwnedTreeItems(notification)) {
            DTreeItemContainer dTreeItemContainer = (DTreeItemContainer)notifier;
            this.analyseDTreeItemContainer(dTreeItemContainer);
        } else if (notification.getFeature() == ViewpointPackage.Literals.DSEMANTIC_DECORATOR__TARGET && notifier instanceof DTree) {
            this.toRefreshInViewer.add(notifier);
        } else if (notification.getFeature() == ViewpointPackage.Literals.DREPRESENTATION_ELEMENT__NAME || notification.getFeature() == TreePackage.Literals.DTREE_ITEM__OWNED_STYLE) {
            this.toUpdateInViewer.add(notifier);
        } else if (this.isExpansionChange(notification)) {
            DTreeItem dTreeItem = (DTreeItem)notifier;
            this.analyseExpansion(dTreeItem);
        } else if (this.isTreeItemStyleAttributeChange(notification)) {
            TreeItemStyle treeItemStyle = (TreeItemStyle)notifier;
            DTreeItem dTreeItem = (DTreeItem)treeItemStyle.eContainer();
            if (dTreeItem != null) {
                this.toUpdateInViewer.add(dTreeItem);
            }
        } else if (notification.getNotifier() instanceof TreeItemStyle && this.isRGBValuesChange(notification)) {
            this.toUpdateInViewer.add(notification.getNotifier());
        }
    }

    private boolean isDTreeItemContainerOwnedTreeItems(Notification notification) {
        return notification.getFeature() == TreePackage.Literals.DTREE_ITEM_CONTAINER__OWNED_TREE_ITEMS;
    }

    private void analyseDTreeItemContainer(DTreeItemContainer dTreeItemContainer) {
        DTreeItem dTreeItem;
        this.toRefreshInViewer.add(dTreeItemContainer);
        if (dTreeItemContainer instanceof DTreeItem && (dTreeItem = (DTreeItem)dTreeItemContainer).isExpanded()) {
            this.toExpands.add(dTreeItem);
            this.analyseExpansionStateOfCreatedChildren((Collection<DTreeItem>)dTreeItem.getOwnedTreeItems());
        }
    }

    private void analyseExpansionStateOfCreatedChildren(Collection<DTreeItem> ownedTreeItems) {
        for (DTreeItem dTreeItem : ownedTreeItems) {
            if (!dTreeItem.isExpanded()) continue;
            this.toExpands.add(dTreeItem);
            this.analyseExpansionStateOfCreatedChildren((Collection<DTreeItem>)dTreeItem.getOwnedTreeItems());
        }
    }

    private boolean isExpansionChange(Notification notification) {
        return notification.getFeature() == TreePackage.Literals.DTREE_ITEM__EXPANDED;
    }

    private void analyseExpansion(DTreeItem dTreeItem) {
        if (dTreeItem.isExpanded()) {
            this.toExpands.add(dTreeItem);
        } else {
            this.toCollapses.add(dTreeItem);
        }
    }

    private boolean isTreeItemStyleAttributeChange(Notification notification) {
        return notification.getFeature() != StylePackage.Literals.STYLE_DESCRIPTION && notification.getFeature() != ViewpointPackage.Literals.CUSTOMIZABLE__CUSTOM_FEATURES && notification.getNotifier() instanceof TreeItemStyle;
    }

    private boolean isRGBValuesChange(Notification notification) {
        return notification.getFeature() instanceof EAttribute && ((EAttribute)notification.getFeature()).getEType() == ViewpointPackage.Literals.RGB_VALUES;
    }

    private void updateDTreeViewer() {
        if (!(this.toRefreshInViewer.isEmpty() && this.toUpdateInViewer.isEmpty() && this.toCollapses.isEmpty() && this.toExpands.isEmpty())) {
            Object[] objectsToUpdateInViewer = Sets.difference(this.toUpdateInViewer, this.toRefreshInViewer).toArray(new Object[0]);
            TreeUIUpdaterRunnable runnable = new TreeUIUpdaterRunnable(this.dTreeViewer, this.toRefreshInViewer, objectsToUpdateInViewer, this.toExpands, this.toCollapses);
            EclipseUIUtil.displayAsyncExec((Runnable)runnable);
        }
    }

    public void dispose() {
        if (this.getTarget() != null) {
            this.getTarget().removeResourceSetListener((ResourceSetListener)this);
        }
        this.dTreeViewer = null;
        this.toExpands = null;
        this.toCollapses = null;
        this.toRefreshInViewer = null;
        this.toUpdateInViewer = null;
    }
}

