/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.fx.internal.projects;

import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.client.ESRemoteProject;
import org.eclipse.emf.emfstore.client.ESServer;
import org.eclipse.emf.emfstore.client.ESUsersession;
import org.eclipse.emf.emfstore.client.ESWorkspace;
import org.eclipse.emf.emfstore.client.observer.ESLoginObserver;
import org.eclipse.emf.emfstore.client.observer.ESLogoutObserver;
import org.eclipse.emf.emfstore.client.observer.ESShareObserver;
import org.eclipse.emf.emfstore.common.ESObserver;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.server.exceptions.ESException;

public class EmfStoreRemoteProjectTreeItem
extends TreeItem<Object> {
    private ObservableList<TreeItem<Object>> children = FXCollections.unmodifiableObservableList((ObservableList)super.getChildren());

    public EmfStoreRemoteProjectTreeItem(Object root) {
        super(root);
        this.updateChildren();
        ESWorkspaceProviderImpl.getObserverBus().register((ESObserver)new ESLoginObserver(){

            public void loginCompleted(ESUsersession session) {
                try {
                    if (!EmfStoreRemoteProjectTreeItem.this.getValue().equals(session.getServer())) {
                        return;
                    }
                    EmfStoreRemoteProjectTreeItem.this.updateServer(session.getServer(), session);
                }
                catch (ESException e) {
                    e.printStackTrace();
                }
            }
        });
        ESWorkspaceProviderImpl.getObserverBus().register((ESObserver)new ESShareObserver(){

            public void shareDone(ESLocalProject localProject) {
                try {
                    ESRemoteProject remoteProject = localProject.getRemoteProject();
                    if (!EmfStoreRemoteProjectTreeItem.this.getValue().equals(remoteProject.getServer())) {
                        return;
                    }
                    EmfStoreRemoteProjectTreeItem.this.updateServer(remoteProject.getServer(), remoteProject.getServer().getLastUsersession());
                }
                catch (ESException e) {
                    e.printStackTrace();
                }
            }
        });
        ESWorkspaceProviderImpl.getObserverBus().register((ESObserver)new ESLoginObserver(){

            public void loginCompleted(ESUsersession session) {
                if (!EmfStoreRemoteProjectTreeItem.this.getValue().equals(session.getServer())) {
                    return;
                }
                try {
                    EmfStoreRemoteProjectTreeItem.this.updateServer(session.getServer(), session);
                }
                catch (ESException e) {
                    e.printStackTrace();
                }
            }
        });
        ESWorkspaceProviderImpl.getObserverBus().register((ESObserver)new ESLogoutObserver(){

            public void logoutCompleted(ESUsersession session) {
                if (!EmfStoreRemoteProjectTreeItem.this.getValue().equals(session.getServer())) {
                    return;
                }
                try {
                    EmfStoreRemoteProjectTreeItem.this.updateServer(session.getServer(), session);
                }
                catch (ESException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void updateChildren() {
        Object selectedValue = this.getValue();
        if (ESWorkspace.class.isInstance(selectedValue)) {
            this.updateWorkspace((ESWorkspace)selectedValue);
        } else if (ESServer.class.isInstance(selectedValue)) {
            ESServer server = (ESServer)selectedValue;
            try {
                this.updateServer(server, server.getLastUsersession());
            }
            catch (ESException eSException) {}
        }
    }

    private void updateServer(ESServer selectedValue, ESUsersession session) throws ESException {
        if (session == null) {
            return;
        }
        ObservableList children = super.getChildren();
        children.clear();
        if (session.isLoggedIn()) {
            for (ESRemoteProject project : selectedValue.getRemoteProjects(session)) {
                children.add((Object)new EmfStoreRemoteProjectTreeItem(project));
            }
        }
    }

    private void updateWorkspace(ESWorkspace workspace) {
        ObservableList children = super.getChildren();
        children.clear();
        for (ESServer server : workspace.getServers()) {
            children.add((Object)new EmfStoreRemoteProjectTreeItem(server));
        }
    }

    public ObservableList<TreeItem<Object>> getChildren() {
        return this.children;
    }
}

