/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.spi.swt.reference;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.internal.swt.Activator;
import org.eclipse.emf.ecp.edit.internal.swt.util.OverlayImageDescriptor;
import org.eclipse.emf.ecp.edit.spi.ReferenceService;
import org.eclipse.emf.ecp.edit.spi.swt.actions.ECPSWTAction;
import org.eclipse.emf.ecp.edit.spi.swt.util.ECPDialogExecutor;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emfforms.spi.localization.LocalizationServiceHelper;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;

public class AddReferenceAction
extends ECPSWTAction {
    private final ReferenceService referenceService;

    public AddReferenceAction(EditingDomain editingDomain, EStructuralFeature.Setting setting, IItemPropertyDescriptor itemPropertyDescriptor, ReferenceService referenceService) {
        super(editingDomain, setting);
        this.referenceService = referenceService;
        EReference eReference = (EReference)setting.getEStructuralFeature();
        EObject obj = null;
        if (!eReference.getEReferenceType().isAbstract()) {
            obj = eReference.getEReferenceType().getEPackage().getEFactoryInstance().create(eReference.getEReferenceType());
        }
        IItemLabelProvider labelProvider = itemPropertyDescriptor.getLabelProvider((Object)setting.getEObject());
        Object labelProviderImageResult = labelProvider.getImage((Object)obj);
        ImageData imageData = null;
        if (ComposedImage.class.isInstance(labelProviderImageResult)) {
            labelProviderImageResult = ((ComposedImage)labelProviderImageResult).getImages().get(0);
        }
        if (URI.class.isInstance(labelProviderImageResult)) {
            try {
                labelProviderImageResult = new URL(((URI)labelProviderImageResult).toString());
            }
            catch (MalformedURLException ex) {
                Activator.logException(ex);
            }
        }
        imageData = URL.class.isInstance(labelProviderImageResult) ? Activator.getImageData((URL)labelProviderImageResult) : Activator.getImageData(null);
        String overlayString = "icons/link_overlay.png";
        if (eReference.isContainment()) {
            overlayString = "icons/containment_overlay.png";
        }
        ImageDescriptor addOverlay = Activator.getImageDescriptor(overlayString);
        OverlayImageDescriptor imageDescriptor = new OverlayImageDescriptor(imageData, addOverlay, 2);
        this.setImageDescriptor((ImageDescriptor)imageDescriptor);
        String attribute = itemPropertyDescriptor.getDisplayName(null);
        if (attribute.endsWith("ies")) {
            attribute = String.valueOf(attribute.substring(0, attribute.length() - 3)) + "y";
        } else if (attribute.endsWith("s")) {
            attribute = attribute.substring(0, attribute.length() - 1);
        }
        this.setToolTipText(String.valueOf(LocalizationServiceHelper.getString(((Object)((Object)this)).getClass(), (String)"AddReferenceAction_Link")) + attribute);
    }

    public void run() {
        EReference eReference = (EReference)this.getSetting().getEStructuralFeature();
        if (eReference.isContainment()) {
            MessageDialog dialog = this.getContainmentWarningDialog();
            new ECPDialogExecutor((Dialog)dialog){

                @Override
                public void handleResult(int codeResult) {
                    if (codeResult == 0) {
                        AddReferenceAction.this.addExistingElementsToReferenceService(AddReferenceAction.this.getSetting().getEObject(), (EReference)AddReferenceAction.this.getSetting().getEStructuralFeature());
                    }
                }
            }.execute();
        }
        this.addExistingElementsToReferenceService(this.getSetting().getEObject(), (EReference)this.getSetting().getEStructuralFeature());
    }

    private void addExistingElementsToReferenceService(EObject eObject, EReference eReference) {
        if (this.referenceService == null) {
            return;
        }
        this.referenceService.addExistingModelElements(eObject, eReference);
    }

    private MessageDialog getContainmentWarningDialog() {
        return new MessageDialog(null, LocalizationServiceHelper.getString(AddReferenceAction.class, (String)"AddReferenceAction_Confirmation"), null, LocalizationServiceHelper.getString(AddReferenceAction.class, (String)"AddReferenceAction_Warning"), 4, new String[]{LocalizationServiceHelper.getString(AddReferenceAction.class, (String)"AddReferenceAction_Yes"), LocalizationServiceHelper.getString(AddReferenceAction.class, (String)"AddReferenceAction_No")}, 0);
    }
}

