/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.domainexpander.defaultheuristic;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.common.spi.asserts.Assert;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsDMRExpander;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsExpandingFailedException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(name="EMFFormsDomainExpanderDefaultHeuristic")
public class EMFFormsDMRExpanderDefaultHeuristic
implements EMFFormsDMRExpander {
    private ReportService reportService;

    @Reference(unbind="-")
    protected void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public void prepareDomainObject(VDomainModelReference domainModelReference, EObject domainObject) throws EMFFormsExpandingFailedException {
        Assert.create((Object)domainModelReference).notNull();
        Assert.create((Object)domainObject).notNull();
        Assert.create((Object)domainModelReference).ofClass(VFeaturePathDomainModelReference.class);
        VFeaturePathDomainModelReference featurePathDMR = (VFeaturePathDomainModelReference)VFeaturePathDomainModelReference.class.cast(domainModelReference);
        if (featurePathDMR.getDomainModelEFeature() == null) {
            throw new EMFFormsExpandingFailedException("The domain model feature of the given feature path DMR must not be null.");
        }
        EObject currentResolvedEObject = domainObject;
        ArrayList currentLeftReferences = new ArrayList(featurePathDMR.getDomainModelEReferencePath());
        for (EReference eReference : featurePathDMR.getDomainModelEReferencePath()) {
            if (!currentResolvedEObject.eClass().getEAllReferences().contains((Object)eReference)) {
                throw new EMFFormsExpandingFailedException("The path defined in the given domain model reference is not compatible with the domain object because the reference requires non available references.");
            }
            if (eReference.isMany()) break;
            if (!eReference.getEContainingClass().isInstance((Object)currentResolvedEObject)) {
                throw new EMFFormsExpandingFailedException("The containing class of a reference does not match the actual object.");
            }
            EObject child = (EObject)currentResolvedEObject.eGet((EStructuralFeature)eReference);
            if (child == null) {
                if (!eReference.getEReferenceType().isAbstract() && !eReference.getEReferenceType().isInterface()) {
                    child = EcoreUtil.create((EClass)eReference.getEReferenceType());
                } else if (currentLeftReferences.size() == 1 && !featurePathDMR.getDomainModelEFeature().getEContainingClass().isAbstract() && !featurePathDMR.getDomainModelEFeature().getEContainingClass().isInterface()) {
                    child = EcoreUtil.create((EClass)featurePathDMR.getDomainModelEFeature().getEContainingClass());
                }
                currentResolvedEObject.eSet((EStructuralFeature)eReference, (Object)child);
            }
            if (child == null) break;
            currentResolvedEObject = child;
            currentLeftReferences.remove(eReference);
        }
    }

    public double isApplicable(VDomainModelReference domainModelReference) {
        if (domainModelReference == null) {
            this.reportService.report(new AbstractReport("Warning: The given domain model reference was null."));
            return NOT_APPLICABLE;
        }
        if (VFeaturePathDomainModelReference.class.isInstance(domainModelReference)) {
            return 1.0;
        }
        return NOT_APPLICABLE;
    }
}

