/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.model.common;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecp.view.model.common.ECPRendererTester;
import org.eclipse.emf.ecp.view.model.common.SimpleControlRendererTester;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VElement;

public class NumberControlRendererTester
implements ECPRendererTester {
    private static Set<NumberTester> testers = new LinkedHashSet<NumberTester>();

    static {
        testers.add(new NumberTester(Integer.class));
        testers.add(new NumberTester(Long.class));
        testers.add(new NumberTester(Float.class));
        testers.add(new NumberTester(Double.class));
        testers.add(new NumberTester(BigInteger.class));
        testers.add(new NumberTester(BigDecimal.class));
        testers.add(new NumberTester(Short.class));
    }

    @Override
    public int isApplicable(VElement vElement, ViewModelContext viewModelContext) {
        int maxResult = -1;
        for (NumberTester tester : testers) {
            int result = tester.isApplicable(vElement, viewModelContext);
            if (result <= maxResult) continue;
            maxResult = result;
        }
        return maxResult;
    }

    private static class NumberTester
    extends SimpleControlRendererTester {
        private final Class<?> clazz;

        NumberTester(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        protected boolean isSingleValue() {
            return true;
        }

        @Override
        protected int getPriority() {
            return 2;
        }

        @Override
        protected Class<?> getSupportedClassType() {
            return this.clazz;
        }
    }
}

