/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.core.layout;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emfforms.spi.swt.core.layout.EMFFormsSWTLayoutOptimizer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class EMFFormsSWTLayoutDelayed
implements EMFFormsSWTLayoutOptimizer {
    private Set<Composite> requestedLayouts = new LinkedHashSet<Composite>();
    private Thread thread;

    @Override
    public synchronized void layout(Composite parent) {
        this.getRequestedLayouts().add(parent);
        this.layoutDelayed();
    }

    private synchronized void layoutDelayed() {
        if (this.thread != null || this.getRequestedLayouts().isEmpty()) {
            return;
        }
        final Display defaultDisplay = Display.getDefault();
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                final Set toLayout = EMFFormsSWTLayoutDelayed.this.exchangeRequestedLayouts();
                defaultDisplay.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        for (Composite composite : toLayout) {
                            if (composite.isDisposed()) continue;
                            composite.layout(true, true);
                        }
                        EMFFormsSWTLayoutDelayed.this.thread = null;
                        EMFFormsSWTLayoutDelayed.this.layoutDelayed();
                    }
                });
            }
        });
        this.thread.start();
    }

    private synchronized Set<Composite> getRequestedLayouts() {
        return this.requestedLayouts;
    }

    private synchronized void setRequestedLayouts(Set<Composite> requestedLayouts) {
        this.requestedLayouts = requestedLayouts;
    }

    private synchronized Set<Composite> exchangeRequestedLayouts() {
        LinkedHashSet<Composite> toLayout = new LinkedHashSet<Composite>(this.getRequestedLayouts());
        this.setRequestedLayouts(new LinkedHashSet<Composite>());
        return toLayout;
    }
}

