/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.internal.swt.table;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.internal.swt.Activator;
import org.eclipse.emf.ecp.edit.internal.swt.controls.NumericalHelper;
import org.eclipse.emf.ecp.edit.spi.ViewLocaleService;
import org.eclipse.emf.ecp.edit.spi.swt.table.ECPCellEditor;
import org.eclipse.emf.ecp.edit.spi.swt.util.ECPDialogExecutor;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emfforms.spi.common.locale.EMFFormsLocaleProvider;
import org.eclipse.emfforms.spi.localization.LocalizationServiceHelper;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.CellEditorProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class NumberCellEditor
extends TextCellEditor
implements ECPCellEditor {
    private EStructuralFeature eStructuralFeature;
    private ViewModelContext viewModelContext;
    @Deprecated
    private ViewLocaleService localeService;
    private EMFFormsLocaleProvider localeProvider;

    public NumberCellEditor(Composite parent) {
        super(parent, 131072);
    }

    public NumberCellEditor(Composite parent, int style) {
        super(parent, style | 0x20000);
    }

    @Override
    public IValueProperty getValueProperty() {
        return CellEditorProperties.control().value((IValueProperty)WidgetProperties.text((int)16));
    }

    @Override
    public void instantiate(EStructuralFeature eStructuralFeature, ViewModelContext viewModelContext) {
        this.eStructuralFeature = eStructuralFeature;
        this.viewModelContext = viewModelContext;
        this.getControl().setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_edit_cellEditor_numberical");
        this.localeService = (ViewLocaleService)viewModelContext.getService(ViewLocaleService.class);
        this.localeProvider = (EMFFormsLocaleProvider)viewModelContext.getService(EMFFormsLocaleProvider.class);
    }

    @Override
    public String getFormatedString(Object value) {
        if (value == null) {
            this.setErrorMessage(LocalizationServiceHelper.getString(this.getClass(), (String)"NumberCellEditor_ValueIsNull"));
            return "";
        }
        DecimalFormat format = NumericalHelper.setupFormat(this.getLocale(), this.getInstanceClass());
        return format.format(value);
    }

    private Locale getLocale() {
        if (this.localeService != null) {
            return this.localeService.getLocale();
        }
        if (this.localeProvider != null) {
            return this.localeProvider.getLocale();
        }
        return Locale.getDefault();
    }

    @Override
    public int getColumnWidthWeight() {
        return 50;
    }

    @Override
    public UpdateValueStrategy getTargetToModelStrategy(DataBindingContext databindingContext) {
        return new TargetToModelStrategy(databindingContext);
    }

    @Override
    public UpdateValueStrategy getModelToTargetStrategy(DataBindingContext databindingContext) {
        return new EMFUpdateValueStrategy(){

            public Object convert(Object value) {
                if (value == null) {
                    return "";
                }
                DecimalFormat format = NumericalHelper.setupFormat(NumberCellEditor.this.getLocale(), NumberCellEditor.this.getInstanceClass());
                return format.format(value);
            }
        };
    }

    private Class<?> getInstanceClass() {
        return this.eStructuralFeature.getEType().getInstanceClass();
    }

    private Text getText() {
        return this.text;
    }

    @Override
    public void setEditable(boolean editable) {
        if (this.getText() != null) {
            this.getText().setEditable(editable);
        }
    }

    @Override
    public Image getImage(Object value) {
        return null;
    }

    @Override
    public int getMinWidth() {
        return 0;
    }

    private final class TargetToModelStrategy
    extends EMFUpdateValueStrategy {
        private final DataBindingContext databindingContext;

        private TargetToModelStrategy(DataBindingContext databindingContext) {
            this.databindingContext = databindingContext;
        }

        public Object convert(Object value) {
            String formatedNumber;
            DecimalFormat format;
            block18: {
                format = NumericalHelper.setupFormat(NumberCellEditor.this.getLocale(), NumberCellEditor.this.getInstanceClass());
                try {
                    Number number = null;
                    if (value == null) {
                        number = NumericalHelper.getDefaultValue(NumberCellEditor.this.getInstanceClass());
                    } else {
                        ParsePosition pp = new ParsePosition(0);
                        number = format.parse((String)value, pp);
                        if (pp.getErrorIndex() != -1 || pp.getIndex() != ((String)value).length()) {
                            return this.revertToOldValue(value);
                        }
                        if (NumericalHelper.isInteger(NumberCellEditor.this.getInstanceClass())) {
                            boolean maxValue = false;
                            Class instanceClass = NumberCellEditor.this.getInstanceClass();
                            String formatedValue = "";
                            try {
                                if (Integer.class.isAssignableFrom(instanceClass) || Integer.class.getField("TYPE").get(null).equals(instanceClass)) {
                                    if (Integer.MAX_VALUE == number.intValue()) {
                                        maxValue = true;
                                        formatedValue = format.format(Integer.MAX_VALUE);
                                    }
                                } else if ((Long.class.isAssignableFrom(instanceClass) || Long.class.getField("TYPE").get(null).equals(instanceClass)) && Long.MAX_VALUE == number.longValue()) {
                                    maxValue = true;
                                    formatedValue = format.format(Long.MAX_VALUE);
                                }
                            }
                            catch (IllegalArgumentException ex) {
                                Activator.logException(ex);
                            }
                            catch (SecurityException ex) {
                                Activator.logException(ex);
                            }
                            catch (IllegalAccessException ex) {
                                Activator.logException(ex);
                            }
                            catch (NoSuchFieldException ex) {
                                Activator.logException(ex);
                            }
                            if (maxValue) {
                                NumberCellEditor.this.getText().setText(formatedValue);
                                return NumericalHelper.numberToInstanceClass(number, NumberCellEditor.this.getInstanceClass());
                            }
                        }
                    }
                    formatedNumber = "";
                    if (number != null) {
                        formatedNumber = format.format(number);
                    }
                    NumberCellEditor.this.getText().setText(formatedNumber);
                    if (formatedNumber.length() != 0) break block18;
                    return null;
                }
                catch (ParseException ex) {
                    return this.revertToOldValue(value);
                }
            }
            return NumericalHelper.numberToInstanceClass(format.parse(formatedNumber), NumberCellEditor.this.getInstanceClass());
        }

        private Object revertToOldValue(Object value) {
            if (NumberCellEditor.this.eStructuralFeature.getDefaultValue() == null && (value == null || value.equals(""))) {
                return null;
            }
            Object result = null;
            MessageDialog messageDialog = new MessageDialog(NumberCellEditor.this.text.getShell(), LocalizationServiceHelper.getString(((Object)((Object)this)).getClass(), (String)"NumberCellEditor_InvalidNumber"), null, LocalizationServiceHelper.getString(((Object)((Object)this)).getClass(), (String)"NumberCellEditor_NumberYouEnteredIsInvalid"), 1, new String[]{JFaceResources.getString((String)"ok")}, 0);
            new ECPDialogExecutor((Dialog)messageDialog){

                @Override
                public void handleResult(int codeResult) {
                }
            }.execute();
            this.databindingContext.updateTargets();
            if (NumberCellEditor.this.eStructuralFeature.isUnsettable()) {
                return SetCommand.UNSET_VALUE;
            }
            return result;
        }
    }
}

